/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.restclient;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.quarkus.arc.Unremovable;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Collections;
import java.util.List;

@Unremovable
@Provider
public class OpenTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT = "otel.span.client.context";
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT = "otel.span.client.parentContext";
    public static final String REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE = "otel.span.client.scope";
    private static final String VERTX_CONTEXT_PROPERTY = "__context";
    private final Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;

    public OpenTelemetryClientFilter() {
        this(GlobalOpenTelemetry.get());
    }

    @Inject
    public OpenTelemetryClientFilter(OpenTelemetry openTelemetry) {
        ClientAttributesExtractor clientAttributesExtractor = new ClientAttributesExtractor();
        ClientNetAttributesGetter clientNetAttributesExtractor = new ClientNetAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)clientAttributesExtractor));
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor)).addAttributesExtractor(HttpClientAttributesExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor, (NetClientAttributesGetter)clientNetAttributesExtractor)).buildClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
    }

    public void filter(ClientRequestContext request) {
        io.vertx.core.Context vertxContext = OpenTelemetryClientFilter.getVertxContext(request);
        Context parentContext = QuarkusContextStorage.getContext(vertxContext);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (this.instrumenter.shouldStart(parentContext, (Object)request)) {
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = new Scope(){

                public void close() {
                }
            };
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT, (Object)spanContext);
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT, (Object)parentContext);
            request.setProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE, (Object)scope);
        }
    }

    private static io.vertx.core.Context getVertxContext(ClientRequestContext request) {
        io.vertx.core.Context vertxContext = (io.vertx.core.Context)request.getProperty(VERTX_CONTEXT_PROPERTY);
        if (vertxContext == null) {
            return QuarkusContextStorage.getVertxContext();
        }
        return vertxContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext request, ClientResponseContext response) {
        Scope scope = (Scope)request.getProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE);
        if (scope == null) {
            return;
        }
        Context spanContext = (Context)request.getProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT);
        try {
            this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
        }
        finally {
            scope.close();
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_CONTEXT);
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_PARENT_CONTEXT);
            request.removeProperty(REST_CLIENT_OTEL_SPAN_CLIENT_SCOPE);
        }
    }

    static boolean isReactiveClient(ClientRequestContext request) {
        return request.getProperty(VERTX_CONTEXT_PROPERTY) != null;
    }

    private static class ClientNetAttributesGetter
    implements NetClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        private ClientNetAttributesGetter() {
        }

        public String getTransport(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) {
            return "ip_tcp";
        }

        public String getServerAddress(ClientRequestContext clientRequestContext) {
            return clientRequestContext.getUri().getHost();
        }

        public Integer getServerPort(ClientRequestContext clientRequestContext) {
            return clientRequestContext.getUri().getPort();
        }

        public String getNetworkProtocolName(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) {
            return "http";
        }

        public String getNetworkProtocolVersion(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) {
            return null;
        }
    }

    private static class ClientAttributesExtractor
    implements HttpClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        private ClientAttributesExtractor() {
        }

        public String getUrlFull(ClientRequestContext request) {
            URI uri = request.getUri();
            if (uri.getUserInfo() != null) {
                return UriBuilder.fromUri((URI)uri).userInfo(null).build(new Object[0]).toString();
            }
            return uri.toString();
        }

        public String getHttpRequestMethod(ClientRequestContext request) {
            return request.getMethod();
        }

        public List<String> getHttpRequestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public Integer getHttpResponseStatusCode(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext, Throwable error) {
            return clientResponseContext.getStatus();
        }

        public List<String> getHttpResponseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }
    }

    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }
    }
}

