/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.EventBusInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.HttpInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxMetricsFactory;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracingFactory;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.SqlClientInstrumenterVertxTracer;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Consumer;

@Recorder
public class InstrumentationRecorder {
    public static final OpenTelemetryVertxTracingFactory FACTORY = new OpenTelemetryVertxTracingFactory();

    public Consumer<VertxOptions> getVertxTracingOptions() {
        TracingOptions tracingOptions = new TracingOptions().setFactory((VertxTracerFactory)FACTORY);
        return vertxOptions -> vertxOptions.setTracingOptions(tracingOptions);
    }

    public void setupVertxTracer(BeanContainer beanContainer) {
        OpenTelemetry openTelemetry = (OpenTelemetry)beanContainer.beanInstance(OpenTelemetry.class, new Annotation[0]);
        OpenTelemetryVertxTracer openTelemetryVertxTracer = new OpenTelemetryVertxTracer(List.of(new HttpInstrumenterVertxTracer(openTelemetry), new EventBusInstrumenterVertxTracer(openTelemetry), new SqlClientInstrumenterVertxTracer(openTelemetry)));
        FACTORY.getVertxTracerDelegator().setDelegate(openTelemetryVertxTracer);
    }

    public Consumer<VertxOptions> getVertxTracingMetricsOptions() {
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new OpenTelemetryVertxMetricsFactory());
        return vertxOptions -> vertxOptions.setMetricsOptions(metricsOptions);
    }
}

