/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import java.util.List;
import java.util.Map;

public class TracerUtil {
    private TracerUtil() {
    }

    public static Resource mapResourceAttributes(List<String> resourceAttributes, String serviceName) {
        if (resourceAttributes.isEmpty()) {
            return Resource.empty();
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        Map<String, String> attrNameToValue = OpenTelemetryUtil.convertKeyValueListToMap(resourceAttributes);
        if (serviceName != null) {
            attrNameToValue.put(ResourceAttributes.SERVICE_NAME.getKey(), serviceName);
        }
        attrNameToValue.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return Resource.create((Attributes)attributesBuilder.build());
    }
}

