/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp;

import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.CompressionType;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.LateBoundBatchSpanProcessor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@Recorder
public class OtlpRecorder {
    static String resolveEndpoint(OtlpExporterRuntimeConfig runtimeConfig) {
        String endpoint = runtimeConfig.traces().legacyEndpoint().filter(OtlpRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.traces().endpoint().filter(OtlpRecorder::excludeDefaultEndpoint).orElse(runtimeConfig.endpoint().filter(OtlpRecorder::excludeDefaultEndpoint).orElse("http://localhost:4317/")));
        return endpoint.trim();
    }

    private static boolean excludeDefaultEndpoint(String endpoint) {
        return !"http://localhost:4317/".equals(endpoint);
    }

    public void installBatchSpanProcessorForOtlp(OTelRuntimeConfig otelRuntimeConfig, OtlpExporterRuntimeConfig exporterRuntimeConfig, LaunchMode launchMode) {
        if (otelRuntimeConfig.sdkDisabled()) {
            return;
        }
        String endpoint = OtlpRecorder.resolveEndpoint(exporterRuntimeConfig).trim();
        if (endpoint.length() > 0) {
            try {
                SpanExporter spanExporter = CDI.current().select(SpanExporter.class, new Annotation[]{Any.Literal.INSTANCE}).stream().findFirst().orElse(null);
                if (spanExporter == null) {
                    spanExporter = this.createOtlpGrpcSpanExporter(exporterRuntimeConfig, endpoint);
                    LateBoundBatchSpanProcessor delayedProcessor = (LateBoundBatchSpanProcessor)CDI.current().select(LateBoundBatchSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
                    BatchSpanProcessorBuilder processorBuilder = BatchSpanProcessor.builder((SpanExporter)spanExporter);
                    processorBuilder.setScheduleDelay(otelRuntimeConfig.bsp().scheduleDelay());
                    processorBuilder.setMaxQueueSize(otelRuntimeConfig.bsp().maxQueueSize().intValue());
                    processorBuilder.setMaxExportBatchSize(otelRuntimeConfig.bsp().maxExportBatchSize().intValue());
                    processorBuilder.setExporterTimeout(otelRuntimeConfig.bsp().exportTimeout());
                    delayedProcessor.setBatchSpanProcessorDelegate(processorBuilder.build());
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Unable to install OTLP Exporter", iae);
            }
        }
    }

    private OtlpGrpcSpanExporter createOtlpGrpcSpanExporter(OtlpExporterRuntimeConfig exporterRuntimeConfig, String endpoint) {
        final OtlpGrpcSpanExporterBuilder exporterBuilder = OtlpGrpcSpanExporter.builder().setEndpoint(endpoint).setTimeout(exporterRuntimeConfig.traces().timeout());
        exporterRuntimeConfig.traces().headers().ifPresent(new Consumer<List<String>>(){

            @Override
            public void accept(List<String> headers) {
                for (Map.Entry<String, String> entry : OpenTelemetryUtil.convertKeyValueListToMap(headers).entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    exporterBuilder.addHeader(key, value);
                }
            }
        });
        exporterRuntimeConfig.traces().compression().ifPresent(new Consumer<CompressionType>(){

            @Override
            public void accept(CompressionType compression) {
                exporterBuilder.setCompression(compression.getValue());
            }
        });
        if (!exporterRuntimeConfig.traces().protocol().orElse("").equals("http/protobuf")) {
            throw new IllegalStateException("Only the GRPC Exporter is currently supported. Please check `otel.exporter.otlp.traces.protocol` property");
        }
        return exporterBuilder.build();
    }
}

