/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.openshift.client.runtime;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.quarkus.arc.DefaultBean;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class OpenShiftClientProducer {
    private static final Logger LOGGER = Logger.getLogger(OpenShiftClientProducer.class);
    private OpenShiftClient client;

    @DefaultBean
    @Singleton
    @Produces
    public OpenShiftClient openShiftClient(Config config) {
        OpenShiftConfig openShiftConfig = new OpenShiftConfig(config);
        openShiftConfig.setHttp2Disable(config.isHttp2Disable());
        this.client = new DefaultOpenShiftClient(openShiftConfig);
        return this.client;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            LOGGER.info((Object)"Closing OpenShift client");
            this.client.close();
        }
    }
}

