/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import io.quarkus.oidc.client.runtime.OidcClientImpl;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.client.runtime.OidcClientsImpl;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@Recorder
public class OidcClientRecorder {
    private static final Logger LOG = Logger.getLogger(OidcClientRecorder.class);
    private static final String DEFAULT_OIDC_CLIENT_ID = "Default";

    public OidcClients setup(OidcClientsConfig oidcClientsConfig, final TlsConfig tlsConfig, final Supplier<Vertx> vertx) {
        String defaultClientId = oidcClientsConfig.defaultClient.getId().orElse(DEFAULT_OIDC_CLIENT_ID);
        OidcClient defaultClient = OidcClientRecorder.createOidcClient(oidcClientsConfig.defaultClient, defaultClientId, tlsConfig, vertx);
        HashMap<String, OidcClient> staticOidcClients = new HashMap<String, OidcClient>();
        for (Map.Entry<String, OidcClientConfig> config : oidcClientsConfig.namedClients.entrySet()) {
            OidcCommonUtils.verifyConfigurationId((String)defaultClientId, (String)config.getKey(), config.getValue().getId());
            staticOidcClients.put(config.getKey(), OidcClientRecorder.createOidcClient(config.getValue(), config.getKey(), tlsConfig, vertx));
        }
        return new OidcClientsImpl(defaultClient, staticOidcClients, new Function<OidcClientConfig, Uni<OidcClient>>(){

            @Override
            public Uni<OidcClient> apply(OidcClientConfig config) {
                return OidcClientRecorder.createOidcClientUni(config, config.getId().get(), tlsConfig, vertx);
            }
        });
    }

    public Supplier<OidcClient> createOidcClientBean(final OidcClients clients) {
        return new Supplier<OidcClient>(){

            @Override
            public OidcClient get() {
                return clients.getClient();
            }
        };
    }

    public Supplier<OidcClient> createOidcClientBean(final OidcClients clients, final String clientName) {
        return new Supplier<OidcClient>(){

            @Override
            public OidcClient get() {
                return clients.getClient(clientName);
            }
        };
    }

    public Supplier<OidcClients> createOidcClientsBean(final OidcClients clients) {
        return new Supplier<OidcClients>(){

            @Override
            public OidcClients get() {
                return clients;
            }
        };
    }

    protected static OidcClient createOidcClient(OidcClientConfig oidcConfig, String oidcClientId, TlsConfig tlsConfig, Supplier<Vertx> vertx) {
        return (OidcClient)OidcClientRecorder.createOidcClientUni(oidcConfig, oidcClientId, tlsConfig, vertx).await().atMost(oidcConfig.connectionTimeout);
    }

    protected static Uni<OidcClient> createOidcClientUni(final OidcClientConfig oidcConfig, String oidcClientId, TlsConfig tlsConfig, Supplier<Vertx> vertx) {
        if (!oidcConfig.isClientEnabled()) {
            String message = String.format("'%s' client configuration is disabled", oidcClientId);
            LOG.debug((Object)message);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        if (!oidcConfig.getId().isPresent()) {
            oidcConfig.setId(oidcClientId);
        }
        try {
            if (oidcConfig.authServerUrl.isEmpty() && !OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.tokenPath)) {
                throw new ConfigurationException("Either 'quarkus.oidc-client.auth-server-url' or absolute 'quarkus.oidc-client.token-path' URL must be set");
            }
            OidcCommonUtils.verifyEndpointUrl((String)OidcClientRecorder.getEndpointUrl(oidcConfig));
            OidcCommonUtils.verifyCommonConfiguration((OidcCommonConfig)oidcConfig, (boolean)false, (boolean)false);
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getMessage());
            String message = String.format("'%s' client configuration is not initialized", oidcClientId);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        WebClientOptions options = new WebClientOptions();
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (TlsConfig)tlsConfig, (HttpClientOptions)options);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)new io.vertx.mutiny.core.Vertx(vertx.get()), (WebClientOptions)options);
        Uni tokenUrisUni = null;
        if (OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.tokenPath)) {
            tokenUrisUni = Uni.createFrom().item((Object)new OidcConfigurationMetadata((String)oidcConfig.tokenPath.get(), OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.revokePath) ? (String)oidcConfig.revokePath.get() : null));
        } else {
            String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
            tokenUrisUni = oidcConfig.discoveryEnabled.orElse(true) == false ? Uni.createFrom().item((Object)new OidcConfigurationMetadata(OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath), OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.revokePath))) : OidcClientRecorder.discoverTokenUris(client, authServerUriString.toString(), oidcConfig);
        }
        return tokenUrisUni.onItemOrFailure().transform((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, OidcClient>(){

            @Override
            public OidcClient apply(OidcConfigurationMetadata metadata, Throwable t) {
                if (t != null) {
                    throw OidcClientRecorder.toOidcClientException(OidcClientRecorder.getEndpointUrl(oidcConfig), t);
                }
                if (metadata.tokenRequestUri == null) {
                    throw new ConfigurationException("OpenId Connect Provider token endpoint URL is not configured and can not be discovered");
                }
                String grantType = oidcConfig.grant.getType().getGrantType();
                MultiMap tokenGrantParams = null;
                if (oidcConfig.grant.getType() != OidcClientConfig.Grant.Type.REFRESH) {
                    Map<String, String> grantOptions;
                    tokenGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                    OidcClientRecorder.setGrantClientParams(oidcConfig, tokenGrantParams, grantType);
                    if (oidcConfig.getGrantOptions() != null && (grantOptions = oidcConfig.getGrantOptions().get(oidcConfig.grant.getType().name().toLowerCase())) != null) {
                        if (oidcConfig.grant.getType() == OidcClientConfig.Grant.Type.PASSWORD) {
                            tokenGrantParams.add("username", grantOptions.get("username"));
                            tokenGrantParams.add("password", grantOptions.get("password"));
                            for (Map.Entry<String, String> entry : grantOptions.entrySet()) {
                                if ("username".equals(entry.getKey()) || "password".equals(entry.getKey())) continue;
                                tokenGrantParams.add(entry.getKey(), entry.getValue());
                            }
                        } else {
                            tokenGrantParams.addAll(grantOptions);
                        }
                    }
                }
                MultiMap commonRefreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                OidcClientRecorder.setGrantClientParams(oidcConfig, commonRefreshGrantParams, "refresh_token");
                return new OidcClientImpl(client, metadata.tokenRequestUri, metadata.tokenRevokeUri, grantType, tokenGrantParams, commonRefreshGrantParams, oidcConfig);
            }
        });
    }

    private static String getEndpointUrl(OidcClientConfig oidcConfig) {
        return oidcConfig.authServerUrl.isPresent() ? (String)oidcConfig.authServerUrl.get() : (String)oidcConfig.tokenPath.get();
    }

    private static void setGrantClientParams(OidcClientConfig oidcConfig, MultiMap grantParams, String grantType) {
        grantParams.add("grant_type", grantType);
        if (oidcConfig.getScopes().isPresent()) {
            grantParams.add("scope", oidcConfig.getScopes().get().stream().collect(Collectors.joining(" ")));
        }
    }

    private static Uni<OidcConfigurationMetadata> discoverTokenUris(WebClient client, String authServerUrl, OidcClientConfig oidcConfig) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        return OidcCommonUtils.discoverMetadata((WebClient)client, (String)authServerUrl, (long)connectionDelayInMillisecs).onItem().transform(json -> new OidcConfigurationMetadata(json.getString("token_endpoint"), json.getString("revocation_endpoint")));
    }

    protected static OidcClientException toOidcClientException(String authServerUrlString, Throwable cause) {
        return new OidcClientException(OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrlString), cause);
    }

    private static class OidcConfigurationMetadata {
        private final String tokenRequestUri;
        private final String tokenRevokeUri;

        OidcConfigurationMetadata(String tokenRequestUri, String tokenRevokeUri) {
            this.tokenRequestUri = tokenRequestUri;
            this.tokenRevokeUri = tokenRevokeUri;
        }
    }

    private static class DisabledOidcClient
    implements OidcClient {
        String message;

        DisabledOidcClient(String message) {
            this.message = message;
        }

        @Override
        public Uni<Tokens> getTokens(Map<String, String> additionalGrantParameters) {
            throw new DisabledOidcClientException(this.message);
        }

        @Override
        public Uni<Tokens> refreshTokens(String refreshToken, Map<String, String> additionalGrantParameters) {
            throw new DisabledOidcClientException(this.message);
        }

        @Override
        public Uni<Boolean> revokeAccessToken(String accessToken, Map<String, String> additionalParameters) {
            throw new DisabledOidcClientException(this.message);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

