/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class DatabaseListOptions {
    private long maxTime;
    private TimeUnit maxTimeUnit;
    private Bson filter;
    private boolean nameOnly;

    public DatabaseListOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.maxTime = maxTime;
        this.maxTimeUnit = timeUnit;
        return this;
    }

    public DatabaseListOptions filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    public DatabaseListOptions nameOnly(boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public <T> ListDatabasesPublisher<T> apply(ListDatabasesPublisher<T> publisher) {
        ListDatabasesPublisher result = publisher;
        if (this.nameOnly) {
            result = publisher.nameOnly(Boolean.valueOf(this.nameOnly));
        }
        if (this.filter != null) {
            result = publisher.filter(this.filter);
        }
        if (this.maxTime > 0L) {
            result.maxTime(this.maxTime, this.maxTimeUnit);
        }
        return result;
    }
}

