/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.health;

import io.quarkus.kafka.streams.runtime.KafkaStreamsTopologyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.logging.Logger;

@Readiness
@ApplicationScoped
public class KafkaStreamsTopicsHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = Logger.getLogger((String)KafkaStreamsTopicsHealthCheck.class.getName());
    @ConfigProperty(name="quarkus.kafka-streams.topics")
    protected List<String> topics;
    @Inject
    protected KafkaStreamsTopologyManager manager;
    private List<String> trimmedTopics;

    @PostConstruct
    public void init() {
        this.trimmedTopics = new ArrayList<String>(this.topics.size());
        for (String topic : this.topics) {
            this.trimmedTopics.add(topic.trim());
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Kafka Streams topics health check").up();
        try {
            Set<String> missingTopics = this.manager.getMissingTopics(this.trimmedTopics);
            ArrayList<String> availableTopics = new ArrayList<String>(this.trimmedTopics);
            availableTopics.removeAll(missingTopics);
            if (!availableTopics.isEmpty()) {
                builder.withData("available_topics", String.join((CharSequence)",", availableTopics));
            }
            if (!missingTopics.isEmpty()) {
                builder.down().withData("missing_topics", String.join((CharSequence)",", missingTopics));
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"error when retrieving missing topics", (Throwable)e);
            builder.down().withData("technical_error", e.getMessage());
        }
        return builder.build();
    }
}

