/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkus.kafka.client.serialization.ObjectMapperProducer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class ObjectMapperDeserializer<T>
implements Deserializer<T> {
    private final JavaType type;
    private final ObjectMapper objectMapper;

    public ObjectMapperDeserializer(Class<T> type) {
        this(type, ObjectMapperProducer.get());
    }

    public ObjectMapperDeserializer(Class<T> type, ObjectMapper objectMapper) {
        this.type = TypeFactory.defaultInstance().constructType(type);
        this.objectMapper = objectMapper;
    }

    public ObjectMapperDeserializer(TypeReference<T> typeReference) {
        this(typeReference, ObjectMapperProducer.get());
    }

    public ObjectMapperDeserializer(TypeReference<T> typeReference, ObjectMapper objectMapper) {
        this.type = TypeFactory.defaultInstance().constructType(typeReference);
        this.objectMapper = objectMapper;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Object object = this.objectMapper.readValue((InputStream)is, this.type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }
}

