/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.metrics.Counter;
import io.jaegertracing.spi.MetricsFactory;
import io.smallrye.metrics.MetricRegistries;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class QuarkusJaegerMpMetricsFactory
implements MetricsFactory {
    Map<MetricID, JaegerGauge> map = new HashMap<MetricID, JaegerGauge>();
    MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);

    QuarkusJaegerMpMetricsFactory() {
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_baggage_restrictions_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "err")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_baggage_restrictions_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "ok")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_baggage_truncations", MetricType.COUNTER));
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_baggage_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "err")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_baggage_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "ok")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_finished_spans", MetricType.COUNTER));
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_reporter_spans", MetricType.COUNTER), new Tag[]{new Tag("result", "dropped")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_reporter_spans", MetricType.COUNTER), new Tag[]{new Tag("result", "err")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_reporter_spans", MetricType.COUNTER), new Tag[]{new Tag("result", "ok")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_sampler_queries", MetricType.COUNTER), new Tag[]{new Tag("result", "err")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_sampler_queries", MetricType.COUNTER), new Tag[]{new Tag("result", "ok")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_sampler_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "ok")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_sampler_updates", MetricType.COUNTER), new Tag[]{new Tag("result", "err")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_span_context_decoding_errors", MetricType.COUNTER));
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_started_spans", MetricType.COUNTER), new Tag[]{new Tag("sampled", "n")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_started_spans", MetricType.COUNTER), new Tag[]{new Tag("sampled", "y")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_traces", MetricType.COUNTER), new Tag[]{new Tag("sampled", "y"), new Tag("state", "joined")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_traces", MetricType.COUNTER), new Tag[]{new Tag("sampled", "y"), new Tag("state", "started")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_traces", MetricType.COUNTER), new Tag[]{new Tag("sampled", "n"), new Tag("state", "joined")});
        this.registry.counter(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_traces", MetricType.COUNTER), new Tag[]{new Tag("sampled", "n"), new Tag("state", "started")});
        this.registry.register(QuarkusJaegerMpMetricsFactory.meta("jaeger_tracer_reporter_queue_length", MetricType.GAUGE), (Metric)new JaegerGauge());
    }

    public Counter createCounter(String name, Map<String, String> tags) {
        final org.eclipse.microprofile.metrics.Counter counter = this.registry.counter(name, this.toTagArray(tags));
        return new Counter(){

            public void inc(long delta) {
                counter.inc(delta);
            }
        };
    }

    public io.jaegertracing.internal.metrics.Timer createTimer(String name, Map<String, String> tags) {
        final Timer timer = this.registry.timer(name, this.toTagArray(tags));
        return new io.jaegertracing.internal.metrics.Timer(){

            public void durationMicros(long time) {
                timer.update(Duration.of(time, ChronoUnit.MICROS));
            }
        };
    }

    public io.jaegertracing.internal.metrics.Gauge createGauge(String name, Map<String, String> tags) {
        final JaegerGauge gauge = this.getGauge(name, tags);
        return new io.jaegertracing.internal.metrics.Gauge(){

            public void update(long amount) {
                gauge.update(amount);
            }
        };
    }

    JaegerGauge getGauge(String name, Map<String, String> tags) {
        MetricID id = new MetricID(name, this.toTagArray(tags));
        return this.map.computeIfAbsent(id, x -> new JaegerGauge());
    }

    private Tag[] toTagArray(Map<String, String> tags) {
        return (Tag[])tags.entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).toArray(Tag[]::new);
    }

    static Metadata meta(String name, MetricType type) {
        return Metadata.builder().withName(name).withDisplayName(name).withType(type).withUnit("none").withDescription(name).build();
    }

    public static class JaegerGauge
    implements Gauge<Long> {
        private AtomicLong value = new AtomicLong();

        public void update(long value) {
            this.value.set(value);
        }

        public Long getValue() {
            return this.value.get();
        }
    }
}

