/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.cache;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptionContext;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.CacheException;
import org.jboss.logging.Logger;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    protected static final String UNHANDLED_ASYNC_RETURN_TYPE_MSG = "Unhandled async return type";
    private static final Logger LOGGER = Logger.getLogger(CacheInterceptor.class);
    @Inject
    RemoteCacheManager cacheManager;

    protected <T extends Annotation> CacheInterceptionContext<T> getInterceptionContext(final InvocationContext invocationContext, final Class<T> interceptorBindingClass) {
        return this.getArcCacheInterceptionContext(invocationContext, interceptorBindingClass).orElseGet(new Supplier<CacheInterceptionContext<T>>(){

            @Override
            public CacheInterceptionContext<T> get() {
                return CacheInterceptor.this.getNonArcCacheInterceptionContext(invocationContext, interceptorBindingClass);
            }
        });
    }

    private <T extends Annotation> Optional<CacheInterceptionContext<T>> getArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)invocationContext);
        if (bindings == null) {
            LOGGER.trace((Object)"Interceptor bindings not found in ArC");
            return Optional.empty();
        }
        ArrayList<Annotation> interceptorBindings = new ArrayList<Annotation>();
        for (Annotation binding : bindings) {
            if (!interceptorBindingClass.isInstance(binding)) continue;
            interceptorBindings.add(binding);
        }
        return Optional.of(new CacheInterceptionContext(interceptorBindings));
    }

    private <T extends Annotation> CacheInterceptionContext<T> getNonArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        LOGGER.trace((Object)"Retrieving interceptor bindings using reflection");
        ArrayList<Annotation> interceptorBindings = new ArrayList<Annotation>();
        for (Annotation annotation : invocationContext.getMethod().getAnnotations()) {
            if (!interceptorBindingClass.isInstance(annotation)) continue;
            interceptorBindings.add(annotation);
        }
        return new CacheInterceptionContext(interceptorBindings);
    }

    protected Object getCacheKey(Object[] methodParameterValues) {
        if (methodParameterValues == null || methodParameterValues.length == 0) {
            throw new CacheException("Unable to cache without a key");
        }
        if (methodParameterValues.length == 1) {
            return methodParameterValues[0];
        }
        return new RuntimeException("A single parameter is needed. Create a Protobuf schema to create a Composite Key.");
    }

    protected static ReturnType determineReturnType(Class<?> returnType) {
        if (Uni.class.isAssignableFrom(returnType)) {
            return ReturnType.Uni;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return ReturnType.CompletionStage;
        }
        return ReturnType.NonAsync;
    }

    protected Uni<?> asyncInvocationResultToUni(final Object invocationResult, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return (Uni)invocationResult;
        }
        if (returnType == ReturnType.CompletionStage) {
            return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends Object>>(){

                @Override
                public CompletionStage<?> get() {
                    return (CompletionStage)invocationResult;
                }
            });
        }
        throw new CacheException((Throwable)new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected Object createAsyncResult(Uni<Object> cacheValue, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return cacheValue;
        }
        if (returnType == ReturnType.CompletionStage) {
            return cacheValue.subscribeAsCompletionStage();
        }
        throw new CacheException((Throwable)new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected static enum ReturnType {
        NonAsync,
        Uni,
        CompletionStage;

    }
}

