/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.ClassNames;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.session.SearchSession;

@BuildSteps(onlyIf={HibernateSearchEnabled.class})
public class HibernateSearchElasticsearchCdiProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateSearchBeans(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem persistenceUnit : configuredPersistenceUnits) {
            String persistenceUnitName = persistenceUnit.getPersistenceUnitName();
            boolean isDefaultPersistenceUnit = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName);
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateSearchElasticsearchCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPersistenceUnit, SearchMapping.class, recorder.searchMappingSupplier(runtimeConfig, persistenceUnitName, isDefaultPersistenceUnit)));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateSearchElasticsearchCdiProcessor.createSyntheticBean(persistenceUnitName, PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName), SearchSession.class, recorder.searchSessionSupplier(runtimeConfig, persistenceUnitName, isDefaultPersistenceUnit)));
        }
    }

    private static <T> SyntheticBeanBuildItem createSyntheticBean(String persistenceUnitName, boolean isDefaultPersistenceUnit, Class<T> type, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(ApplicationScoped.class)).unremovable()).supplier(supplier).setRuntimeInit();
        if (isDefaultPersistenceUnit) {
            configurator.addQualifier(Default.class);
        }
        configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitName).done();
        configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitName).done();
        return configurator.done();
    }

    @BuildStep
    void registerAnnotations(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{ClassNames.SEARCH_EXTENSION.toString()}).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ClassNames.SEARCH_EXTENSION, DotNames.APPLICATION_SCOPED, false));
    }
}

