/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;

public class FlywayContainersSupplier
implements Supplier<Collection<FlywayContainer>> {
    @Override
    public Collection<FlywayContainer> get() {
        TreeSet<FlywayContainer> containers = new TreeSet<FlywayContainer>(FlywayContainerComparator.INSTANCE);
        containers.addAll(FlywayContainerUtil.getActiveFlywayContainers());
        return containers;
    }

    private static class FlywayContainerComparator
    implements Comparator<FlywayContainer> {
        private static final FlywayContainerComparator INSTANCE = new FlywayContainerComparator();

        private FlywayContainerComparator() {
        }

        @Override
        public int compare(FlywayContainer o1, FlywayContainer o2) {
            String dataSourceName1 = o1.getDataSourceName();
            String dataSourceName2 = o2.getDataSourceName();
            if (DataSourceUtil.isDefault((String)dataSourceName1)) {
                return -1;
            }
            if (DataSourceUtil.isDefault((String)dataSourceName2)) {
                return 1;
            }
            return dataSourceName1.compareTo(dataSourceName2);
        }
    }
}

