/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayContainer;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public final class FlywayContainerUtil {
    private FlywayContainerUtil() {
    }

    public static FlywayContainer getFlywayContainer(String dataSourceName) {
        return (FlywayContainer)Arc.container().instance(FlywayContainer.class, new Annotation[]{FlywayContainerUtil.getFlywayContainerQualifier(dataSourceName)}).get();
    }

    public static List<FlywayContainer> getActiveFlywayContainers() {
        ArrayList<FlywayContainer> result = new ArrayList<FlywayContainer>();
        for (String datasourceName : AgroalDataSourceUtil.activeDataSourceNames()) {
            InstanceHandle handle = Arc.container().instance(FlywayContainer.class, new Annotation[]{FlywayContainerUtil.getFlywayContainerQualifier(datasourceName)});
            if (!handle.isAvailable()) continue;
            result.add((FlywayContainer)handle.get());
        }
        return result;
    }

    public static Annotation getFlywayContainerQualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return FlywayDataSource.FlywayDataSourceLiteral.of(dataSourceName);
    }
}

