/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

public class ElementUtil {
    private static final Pattern REMOVE_LEADING_SPACE = Pattern.compile("^ ", 8);
    private final ProcessingEnvironment processingEnv;

    ElementUtil(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String getQualifiedName(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case DECLARED: {
                return ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().toString();
            }
        }
        return type.toString();
    }

    public String getBinaryName(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
    }

    public String getRelativeBinaryName(TypeElement typeElement) {
        return this.buildRelativeBinaryName(typeElement, new StringBuilder()).toString();
    }

    StringBuilder buildRelativeBinaryName(TypeElement typeElement, StringBuilder builder) {
        Element enclosing = typeElement.getEnclosingElement();
        if (enclosing instanceof TypeElement) {
            this.buildRelativeBinaryName((TypeElement)enclosing, builder);
            builder.append('$');
        }
        builder.append(typeElement.getSimpleName());
        return builder;
    }

    public String simplifyGenericType(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        String simpleName = declaredType.asElement().getSimpleName().toString();
        if (typeArguments.isEmpty()) {
            return simpleName;
        }
        if (typeArguments.size() == 1) {
            return String.format("%s<%s>", simpleName, this.simplifyGenericType(typeArguments.get(0)));
        }
        if (typeArguments.size() == 2) {
            return String.format("%s<%s,%s>", simpleName, this.simplifyGenericType(typeArguments.get(0)), this.simplifyGenericType(typeArguments.get(1)));
        }
        return "unknown";
    }

    public Map<String, AnnotationMirror> getAnnotations(Element element) {
        return element.getAnnotationMirrors().stream().collect(Collectors.toMap(a -> ((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().toString(), Function.identity()));
    }

    public Map<String, Object> getAnnotationValues(AnnotationMirror annotation) {
        return annotation.getElementValues().entrySet().stream().collect(Collectors.toMap(e -> ((ExecutableElement)e.getKey()).toString().substring(0, ((ExecutableElement)e.getKey()).toString().length() - 2), e -> ((AnnotationValue)e.getValue()).getValue()));
    }

    public PackageElement getPackageOf(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getPackageOf(clazz);
    }

    public Name getPackageName(TypeElement clazz) {
        return this.getPackageOf(clazz).getQualifiedName();
    }

    public TypeElement getClassOf(Element e) {
        Element t = e;
        while (!(t instanceof TypeElement)) {
            if (t == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + String.valueOf(e) + " has no enclosing class");
                return null;
            }
            t = t.getEnclosingElement();
        }
        return (TypeElement)t;
    }

    public boolean isAnnotationPresent(Element element, String ... annotationNames) {
        Set<String> annotations = Set.of(annotationNames);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annotations.contains(annotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalClass(TypeElement clazz) {
        try {
            while (clazz.getNestingKind().isNested()) {
                clazz = (TypeElement)clazz.getEnclosingElement();
            }
            this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", clazz.getQualifiedName().toString().replace('.', '/') + ".java");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<String> getJavadoc(Element e) {
        String docComment = this.processingEnv.getElementUtils().getDocComment(e);
        if (docComment == null || docComment.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(REMOVE_LEADING_SPACE.matcher(docComment).replaceAll("").trim());
    }

    public void addMissingJavadocError(Element e) {
        String error = "Unable to find javadoc for config item " + String.valueOf(e.getEnclosingElement()) + " " + String.valueOf(e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, e);
        throw new IllegalStateException(error);
    }

    public boolean isJdkClass(TypeElement e) {
        return e.getQualifiedName().toString().startsWith("java.");
    }
}

