/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryPlatformsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResult;

public class MavenPlatformsResolver
implements RegistryPlatformsResolver {
    private final RegistryPlatformsConfig config;
    private final MavenRegistryArtifactResolver artifactResolver;
    private final MessageWriter log;

    public MavenPlatformsResolver(RegistryPlatformsConfig config, MavenRegistryArtifactResolver artifactResolver, MessageWriter log) {
        this.config = Objects.requireNonNull(config);
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public PlatformCatalog.Mutable resolvePlatforms(String quarkusVersion) throws RegistryResolutionException {
        PlatformCatalog.Mutable catalog;
        ArtifactResult artifactResult;
        ArtifactCoords baseCoords = this.config.getArtifact();
        DefaultArtifact catalogArtifact = new DefaultArtifact(baseCoords.getGroupId(), baseCoords.getArtifactId(), quarkusVersion, baseCoords.getType(), baseCoords.getVersion());
        this.log.debug("Resolving platform catalog %s", new Object[]{catalogArtifact});
        try {
            artifactResult = this.artifactResolver.resolveArtifact((Artifact)catalogArtifact);
        }
        catch (Exception e) {
            this.log.debug("Failed to resolve platform catalog %s", new Object[]{catalogArtifact});
            return null;
        }
        Path jsonFile = artifactResult.getArtifact().getFile().toPath();
        try {
            catalog = PlatformCatalog.mutableFromFile(jsonFile);
        }
        catch (IOException e) {
            throw new RegistryResolutionException("Failed to load platform catalog from " + jsonFile, e);
        }
        try {
            Metadata mavenMetadata = this.artifactResolver.resolveMetadata(artifactResult);
            if (mavenMetadata != null) {
                String lastUpdated;
                String string = lastUpdated = mavenMetadata.getVersioning() == null ? null : mavenMetadata.getVersioning().getLastUpdated();
                if (lastUpdated != null) {
                    catalog.setMetadata("last-updated", lastUpdated);
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to resolve Maven metadata for %s", new Object[]{catalogArtifact});
        }
        return catalog;
    }
}

