/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mariadb.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.common.Labels;
import io.quarkus.devservices.common.Volumes;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MariaDBDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MariaDBDevServicesProcessor.class);
    public static final Integer PORT = 3306;
    public static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMariaDB(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mariadb", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                QuarkusMariaDBContainer container = new QuarkusMariaDBContainer(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusMariaDBContainer)container).withStartupTimeout(arg_0));
                String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                String effectiveDbName = containerConfig.getDbName().orElse(datasourceName.orElse("quarkus"));
                container.withUsername(effectiveUsername).withPassword(effectivePassword).withDatabaseName(effectiveDbName).withReuse(true);
                Labels.addDataSourceLabel((GenericContainer)container, datasourceName);
                Volumes.addVolumes((GenericContainer)container, (Map)containerConfig.getVolumes());
                container.withEnv(containerConfig.getContainerEnv());
                if (containerConfig.getContainerProperties().containsKey(MariaDBDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME)) {
                    container.withConfigurationOverride((String)containerConfig.getContainerProperties().get(MariaDBDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME));
                }
                containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusMariaDBContainer)container).withUrlParam(arg_0, arg_1));
                containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusMariaDBContainer)container).setCommand(arg_0));
                containerConfig.getInitScriptPath().ifPresent(arg_0 -> ((QuarkusMariaDBContainer)container).withInitScript(arg_0));
                container.start();
                LOG.info((Object)"Dev Services for MariaDB started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "MariaDB"));
            }
        });
    }

    private static class QuarkusMariaDBContainer
    extends MariaDBContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMariaDBContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"mariadb"))).asCompatibleSubstituteFor(DockerImageName.parse((String)"mariadb")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mariadb");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), PORT);
            } else {
                this.addExposedPort(PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters("?", "&");
                return "jdbc:mariadb://" + this.hostName + ":" + PORT + "/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:mariadb:", "vertx-reactive:mysql:");
        }
    }
}

