/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.gradle.api.JavaVersion;
import org.gradle.internal.serialize.JavaClassUtil;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader loader;

    public ClassLoaderObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), false, this.loader);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
        catch (UnsupportedClassVersionError e) {
            try {
                Integer majorVersion = JavaClassUtil.getClassMajorVersion(desc.getName(), this.loader);
                if (majorVersion != null) {
                    throw new UnsupportedClassVersionErrorWithJavaVersion(e, JavaVersion.forClassVersion(majorVersion));
                }
                throw e;
            }
            catch (IOException ignored) {
                throw e;
            }
        }
    }

    public static class UnsupportedClassVersionErrorWithJavaVersion
    extends UnsupportedClassVersionError {
        private final JavaVersion version;

        public UnsupportedClassVersionErrorWithJavaVersion(UnsupportedClassVersionError cause, JavaVersion version) {
            super(cause.getMessage());
            this.initCause(cause);
            this.version = version;
        }

        public JavaVersion getVersion() {
            return this.version;
        }
    }
}

