/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformInfo;
import io.quarkus.bootstrap.model.PlatformReleaseInfo;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public class PlatformImportsImpl
implements PlatformImports,
Serializable {
    private static final long serialVersionUID = -1722573527738064746L;
    public static final String PROPERTY_PREFIX = "platform.release-info@";
    public static final char PLATFORM_KEY_STREAM_SEPARATOR = '$';
    public static final char STREAM_VERSION_SEPARATOR = '#';
    private final Map<String, PlatformInfo> allPlatformInfo = new HashMap<String, PlatformInfo>();
    private final Map<String, Collection<ArtifactCoords>> importedPlatformBoms = new HashMap<String, Collection<ArtifactCoords>>();
    private final Map<ArtifactCoords, PlatformImport> platformImports = new HashMap<ArtifactCoords, PlatformImport>();
    final Map<String, String> collectedProps = new HashMap<String, String>();
    private final Collection<ArtifactCoords> platformBoms = new ArrayList<ArtifactCoords>();
    private final Collection<PlatformReleaseInfo> platformReleaseInfo = new ArrayList<PlatformReleaseInfo>();

    private static int requiredIndex(String s, char c, int fromIndex) {
        int i = s.indexOf(c, fromIndex);
        if (i < 0) {
            throw new IllegalArgumentException("Failed to locate '" + c + "' in '" + s + "'");
        }
        return i;
    }

    public static boolean isPlatformReleaseInfo(String s) {
        return s != null && s.startsWith(PROPERTY_PREFIX);
    }

    @Override
    public Collection<PlatformReleaseInfo> getPlatformReleaseInfo() {
        return this.platformReleaseInfo;
    }

    @Override
    public Collection<ArtifactCoords> getImportedPlatformBoms() {
        return this.platformBoms;
    }

    void addPlatformRelease(String propertyName, String propertyValue) {
        int platformKeyStreamSep = PlatformImportsImpl.requiredIndex(propertyName, '$', PROPERTY_PREFIX.length());
        int streamVersionSep = PlatformImportsImpl.requiredIndex(propertyName, '#', platformKeyStreamSep + 1);
        String platformKey = propertyName.substring(PROPERTY_PREFIX.length(), platformKeyStreamSep);
        String streamId = propertyName.substring(platformKeyStreamSep + 1, streamVersionSep);
        String version = propertyName.substring(streamVersionSep + 1);
        this.allPlatformInfo.computeIfAbsent(platformKey, PlatformInfo::new).getOrCreateStream(streamId).addIfNotPresent(version, () -> {
            PlatformReleaseInfo ri = new PlatformReleaseInfo(platformKey, streamId, version, propertyValue);
            this.platformReleaseInfo.add(ri);
            return ri;
        });
    }

    public void addPlatformDescriptor(String groupId, String artifactId, String classifier, String type, String version) {
        ArtifactCoords bomCoords = ArtifactCoords.pom(groupId, artifactId.substring(0, artifactId.length() - "-quarkus-platform-descriptor".length()), version);
        this.platformImports.computeIfAbsent((ArtifactCoords)bomCoords, (Function<ArtifactCoords, PlatformImport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, newPlatformImport(io.quarkus.maven.dependency.ArtifactCoords ), (Lio/quarkus/maven/dependency/ArtifactCoords;)Lio/quarkus/bootstrap/model/PlatformImportsImpl$PlatformImport;)((PlatformImportsImpl)this)).descriptorFound = true;
    }

    public void addPlatformProperties(String groupId, String artifactId, String classifier, String type, String version, Path propsPath) throws AppModelResolverException {
        ArtifactCoords bomCoords = ArtifactCoords.pom(groupId, artifactId.substring(0, artifactId.length() - "-quarkus-platform-properties".length()), version);
        this.platformImports.computeIfAbsent(bomCoords, this::newPlatformImport);
        this.importedPlatformBoms.computeIfAbsent(groupId, g -> new ArrayList());
        if (!this.importedPlatformBoms.get(groupId).contains(bomCoords)) {
            this.importedPlatformBoms.get(groupId).add(bomCoords);
            Properties props = new Properties();
            try (InputStream is = Files.newInputStream(propsPath, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException e) {
                throw new AppModelResolverException("Failed to read properties from " + String.valueOf(propsPath), e);
            }
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                String name = String.valueOf(prop.getKey());
                if (!name.startsWith("platform.")) continue;
                if (PlatformImportsImpl.isPlatformReleaseInfo(name)) {
                    this.addPlatformRelease(name, String.valueOf(prop.getValue()));
                    continue;
                }
                this.collectedProps.putIfAbsent(name, String.valueOf(prop.getValue().toString()));
            }
        }
    }

    private PlatformImport newPlatformImport(ArtifactCoords bom) {
        this.platformBoms.add(bom);
        return new PlatformImport();
    }

    public void setPlatformProperties(Map<String, String> platformProps) {
        this.collectedProps.putAll(platformProps);
    }

    @Override
    public Map<String, String> getPlatformProperties() {
        return this.collectedProps;
    }

    @Override
    public String getMisalignmentReport() {
        StringWriter error = null;
        for (Map.Entry<ArtifactCoords, PlatformImport> pi : this.platformImports.entrySet()) {
            if (pi.getValue().descriptorFound) continue;
            if (error == null) {
                error = new StringWriter();
                error.append("The Quarkus platform properties applied to the project are missing the corresponding Quarkus platform BOM imports: ");
            } else {
                error.append(", ");
            }
            error.append(pi.getKey().toString());
        }
        if (error != null) {
            return error.getBuffer().toString();
        }
        Map<String, List<List<String>>> possibleAlignments = this.getPossibleAlignemnts(this.importedPlatformBoms);
        if (possibleAlignments.isEmpty()) {
            return null;
        }
        error = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(error);){
            writer.append("Some of the imported Quarkus platform BOMs belong to different platform releases. To properly align the platform BOM imports, please, consider one of the following combinations:");
            writer.newLine();
            for (Map.Entry<String, List<List<String>>> entry : possibleAlignments.entrySet()) {
                writer.append("For platform ").append(entry.getKey()).append(':');
                writer.newLine();
                int i = 1;
                for (List<String> boms : entry.getValue()) {
                    writer.append("  ").append(String.valueOf(i++)).append(") ");
                    writer.newLine();
                    for (String bom : boms) {
                        writer.append(" - ").append(bom);
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return error.toString();
    }

    @Override
    public boolean isAligned() {
        return this.isAligned(this.importedPlatformBoms);
    }

    boolean isAligned(Map<String, Collection<ArtifactCoords>> importedPlatformBoms) {
        for (Map.Entry<ArtifactCoords, PlatformImport> entry : this.platformImports.entrySet()) {
            if (entry.getValue().descriptorFound) continue;
            return false;
        }
        for (Map.Entry<Object, Object> entry : importedPlatformBoms.entrySet()) {
            PlatformInfo platformInfo = this.allPlatformInfo.get(entry.getKey());
            if (platformInfo == null || platformInfo.isAligned((Collection)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<List<String>>> getPossibleAlignemnts(Map<String, Collection<ArtifactCoords>> importedPlatformBoms) {
        HashMap<String, List<List<String>>> alignments = new HashMap<String, List<List<String>>>(importedPlatformBoms.size());
        for (Map.Entry<String, Collection<ArtifactCoords>> platformImportedBoms : importedPlatformBoms.entrySet()) {
            PlatformInfo platformInfo = this.allPlatformInfo.get(platformImportedBoms.getKey());
            if (platformInfo == null || platformInfo.isAligned(platformImportedBoms.getValue())) continue;
            alignments.put(platformInfo.getPlatformKey(), platformInfo.getPossibleAlignments(platformImportedBoms.getValue()));
        }
        return alignments;
    }

    Collection<PlatformInfo> getPlatforms() {
        return this.allPlatformInfo.values();
    }

    PlatformInfo getPlatform(String platformKey) {
        return this.allPlatformInfo.get(platformKey);
    }

    private static class PlatformImport
    implements Serializable {
        private static final long serialVersionUID = -400741166176498944L;
        boolean descriptorFound;

        private PlatformImport() {
        }
    }
}

