/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.MutableBaseJvmOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MutableStandardJvmOption
extends MutableBaseJvmOption<MutableStandardJvmOption> {
    public static final String PROPERTY_GROUP_PREFIX = "std.";
    private static final String COMPLETE_PROPERTY_PREFIX = "dev-mode.jvm-option.std.";
    private static final String DASH_DASH = "--";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";

    public static MutableStandardJvmOption fromQuarkusExtensionProperty(String propertyName, String value) {
        String optionName = propertyName.substring(COMPLETE_PROPERTY_PREFIX.length());
        return value.isBlank() ? MutableStandardJvmOption.newInstance(optionName) : MutableStandardJvmOption.newInstance(optionName, value);
    }

    public static MutableStandardJvmOption newInstance(String name) {
        return MutableStandardJvmOption.newInstance(name, null);
    }

    public static MutableStandardJvmOption newInstance(String name, String value) {
        MutableStandardJvmOption result = new MutableStandardJvmOption();
        result.setName(name);
        if (value != null) {
            result.addValue(value);
        }
        return result;
    }

    @Override
    protected String getQuarkusExtensionPropertyPrefix() {
        return COMPLETE_PROPERTY_PREFIX;
    }

    @Override
    public List<String> toCliOptions() {
        switch (this.getName()) {
            case "add-modules": {
                return this.toCliSortedValueList(COMMA);
            }
            case "add-opens": {
                return this.toCliModulePackageList();
            }
        }
        return this.toCliGenericArgument();
    }

    private List<String> toCliModulePackageList() {
        if (!this.hasValue()) {
            return List.of();
        }
        String name = this.getName();
        Collection<String> values = this.getValues();
        if (values.size() == 1) {
            return List.of(DASH_DASH + name + "==" + values.iterator().next());
        }
        HashMap<String, Set> modulePackages = new HashMap<String, Set>(values.size());
        for (String value : values) {
            String[] packageNames;
            int slash = value.indexOf(61);
            if (slash < 1) {
                throw new IllegalArgumentException("Value '" + value + "' does not follow module/package=target-module(,target-module) format");
            }
            Set targetModules = modulePackages.computeIfAbsent(value.substring(0, slash), k -> new HashSet());
            for (String packageName : packageNames = value.substring(slash + 1).split(COMMA)) {
                targetModules.add(packageName);
            }
        }
        String[] modulePackageList = MutableStandardJvmOption.toSortedArray(modulePackages.keySet());
        ArrayList<String> result = new ArrayList<String>(modulePackageList.length * 2);
        for (String modulePackage : modulePackageList) {
            Set targetModules = (Set)modulePackages.get(modulePackage);
            if (targetModules.isEmpty()) continue;
            result.add(DASH_DASH + name);
            StringBuilder sb = new StringBuilder().append(modulePackage).append(EQUALS);
            String[] targetModuleNames = MutableStandardJvmOption.toSortedArray(targetModules);
            MutableStandardJvmOption.appendItems(sb, targetModuleNames, COMMA);
            result.add(sb.toString());
        }
        return result;
    }

    private List<String> toCliSortedValueList(String valueSeparator) {
        if (!this.hasValue()) {
            return List.of();
        }
        StringBuilder sb = new StringBuilder().append(DASH_DASH).append(this.getName()).append(EQUALS);
        Collection<String> values = this.getValues();
        if (values.size() == 1) {
            sb.append(values.iterator().next());
            return List.of(sb.toString());
        }
        MutableStandardJvmOption.appendItems(sb, MutableStandardJvmOption.toSortedArray(values), valueSeparator);
        return List.of(sb.toString());
    }

    private List<String> toCliGenericArgument() {
        return this.getValues().isEmpty() ? List.of(DASH_DASH + this.getName()) : this.toCliSortedValueList(COMMA);
    }

    private static void appendItems(StringBuilder sb, String[] arr, String itemSeparator) {
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(itemSeparator).append(arr[i]);
        }
    }

    private static String[] toSortedArray(Collection<String> value) {
        Object[] arr = value.toArray(new String[0]);
        Arrays.sort(arr);
        return arr;
    }
}

