/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PlatformReleaseInfo
implements Serializable {
    private static final long serialVersionUID = 7751600738849301644L;
    private final String platformKey;
    private final String stream;
    private final String version;
    private final List<ArtifactCoords> boms;

    public PlatformReleaseInfo(String platformKey, String stream, String version, String boms) {
        this.platformKey = platformKey;
        this.stream = stream;
        this.version = version;
        String[] bomCoords = boms.split(",");
        this.boms = new ArrayList<ArtifactCoords>(bomCoords.length);
        for (String s : bomCoords) {
            this.boms.add(GACTV.fromString(s));
        }
    }

    public String getPlatformKey() {
        return this.platformKey;
    }

    public String getStream() {
        return this.stream;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ArtifactCoords> getBoms() {
        return this.boms;
    }

    String getPropertyName() {
        StringBuilder buf = new StringBuilder();
        buf.append("platform.release-info@").append(this.platformKey).append('$').append(this.stream).append('#').append(this.version);
        return buf.toString();
    }

    String getPropertyValue() {
        StringBuilder buf = new StringBuilder();
        List<ArtifactCoords> boms = this.getBoms();
        if (!boms.isEmpty()) {
            buf.append(boms.get(0).toString());
            for (int i = 1; i < boms.size(); ++i) {
                buf.append(',').append(boms.get(i));
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.getPropertyName() + "=" + this.getPropertyValue();
    }
}

