/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.ExtensionDevModeConfig;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface ApplicationModel {
    public ResolvedDependency getAppArtifact();

    public Collection<ResolvedDependency> getDependencies();

    public Iterable<ResolvedDependency> getDependencies(int var1);

    public Iterable<ResolvedDependency> getDependenciesWithAnyFlag(int var1);

    default public Iterable<ResolvedDependency> getDependenciesWithAnyFlag(int ... flags) {
        if (flags.length == 0) {
            throw new IllegalArgumentException("Flags are empty");
        }
        int combined = flags[0];
        for (int i = 1; i < flags.length; ++i) {
            combined |= flags[i];
        }
        return this.getDependenciesWithAnyFlag(combined);
    }

    public Collection<ResolvedDependency> getRuntimeDependencies();

    public PlatformImports getPlatforms();

    default public Map<String, String> getPlatformProperties() {
        PlatformImports platformImports = this.getPlatforms();
        return platformImports == null ? Map.of() : platformImports.getPlatformProperties();
    }

    public Collection<ExtensionCapabilities> getExtensionCapabilities();

    public Set<ArtifactKey> getParentFirst();

    public Set<ArtifactKey> getRunnerParentFirst();

    public Set<ArtifactKey> getLowerPriorityArtifacts();

    public Set<ArtifactKey> getReloadableWorkspaceDependencies();

    public Map<ArtifactKey, Set<String>> getRemovedResources();

    default public WorkspaceModule getApplicationModule() {
        return this.getAppArtifact().getWorkspaceModule();
    }

    default public Collection<WorkspaceModule> getWorkspaceModules() {
        HashMap<WorkspaceModuleId, WorkspaceModule> result = new HashMap<WorkspaceModuleId, WorkspaceModule>();
        ApplicationModel.collectModules(this.getAppArtifact().getWorkspaceModule(), result);
        for (ResolvedDependency d : this.getDependencies()) {
            ApplicationModel.collectModules(d.getWorkspaceModule(), result);
        }
        return result.values();
    }

    private static void collectModules(WorkspaceModule module, Map<WorkspaceModuleId, WorkspaceModule> collected) {
        if (module == null) {
            return;
        }
        collected.putIfAbsent(module.getId(), module);
        WorkspaceModule parent = module.getParent();
        if (parent != null) {
            ApplicationModel.collectModules(parent, collected);
        }
        for (Dependency d : module.getDirectDependencyConstraints()) {
            if (!"import".equals(d.getScope()) || !(d instanceof ResolvedDependency)) continue;
            ApplicationModel.collectModules(((ResolvedDependency)d).getWorkspaceModule(), collected);
        }
    }

    public Collection<ExtensionDevModeConfig> getExtensionDevModeConfig();
}

