/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.JvmOption;
import io.quarkus.bootstrap.model.JvmOptions;
import io.quarkus.bootstrap.model.MutableBaseJvmOption;
import io.quarkus.bootstrap.model.MutableStandardJvmOption;
import io.quarkus.bootstrap.model.MutableXxJvmOption;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JvmOptionsBuilder {
    private Map<String, MutableBaseJvmOption<?>> options = Map.of();

    public static boolean isExtensionDevModeJvmOptionProperty(String name) {
        return name.startsWith("dev-mode.jvm-option.");
    }

    private static String getGroupPrefixForPropertyName(String propName) {
        int i = propName.indexOf(46, "dev-mode.jvm-option.".length() + 1);
        if (i < 0) {
            throw new IllegalArgumentException("Failed to determine JVM option group given property name " + propName);
        }
        return propName.substring("dev-mode.jvm-option.".length(), i + 1);
    }

    JvmOptionsBuilder() {
    }

    public void addFromQuarkusExtensionProperty(String propertyName, String value) {
        String groupPrefix = JvmOptionsBuilder.getGroupPrefixForPropertyName(propertyName);
        String optionName = propertyName.substring("dev-mode.jvm-option.".length() + groupPrefix.length());
        this.addToGroup(groupPrefix, optionName, value);
    }

    private JvmOptionsBuilder addToGroup(String optionGroupPrefix, String optionName, String value) {
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        MutableBaseJvmOption option = this.options.computeIfAbsent(optionName, n -> {
            switch (optionGroupPrefix) {
                case "std.": {
                    return MutableStandardJvmOption.newInstance(optionName);
                }
                case "xx.": {
                    return MutableXxJvmOption.newInstance(optionName);
                }
            }
            throw new IllegalArgumentException("Unrecognized JVM option group prefix " + optionGroupPrefix);
        });
        if (!value.isBlank()) {
            option.addValue(value);
        }
        return this;
    }

    public JvmOptionsBuilder add(String name) {
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        this.options.computeIfAbsent(name, n -> MutableStandardJvmOption.newInstance(name));
        return this;
    }

    public JvmOptionsBuilder add(String name, String value) {
        MutableBaseJvmOption<?> arg;
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        if ((arg = this.options.get(name)) == null) {
            this.options.put(name, MutableStandardJvmOption.newInstance(name, value));
        } else {
            arg.addValue(value);
        }
        return this;
    }

    public JvmOptionsBuilder addAll(String name, Collection<String> values) {
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        MutableBaseJvmOption option = this.options.computeIfAbsent(name, n -> MutableStandardJvmOption.newInstance(name));
        for (String value : values) {
            option.addValue(value);
        }
        return this;
    }

    public JvmOptionsBuilder addXxOption(String name, String value) {
        MutableBaseJvmOption<?> arg;
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        if ((arg = this.options.get(name)) == null) {
            this.options.put(name, MutableXxJvmOption.newInstance(name, value));
        } else {
            arg.addValue(value);
        }
        return this;
    }

    public JvmOptionsBuilder addAll(JvmOptions options) {
        if (this.options.isEmpty()) {
            this.options = new HashMap();
        }
        for (JvmOption option : options.asCollection()) {
            if (option.hasValue()) {
                MutableBaseJvmOption existing = this.options.putIfAbsent(option.getName(), (MutableBaseJvmOption)option);
                if (existing != null) {
                    for (String value : option.getValues()) {
                        existing.addValue(value);
                    }
                }
                this.addAll(option.getName(), option.getValues());
                continue;
            }
            this.options.putIfAbsent(option.getName(), (MutableBaseJvmOption)option);
        }
        return this;
    }

    public Collection<JvmOption> getOptions() {
        return List.copyOf(this.options.values());
    }

    public boolean contains(String optionName) {
        for (MutableBaseJvmOption<?> option : this.options.values()) {
            if (!option.getName().equals(optionName)) continue;
            return true;
        }
        return false;
    }

    public JvmOptions build() {
        return new JvmOptionsImpl(this.options.isEmpty() ? List.of() : List.copyOf(this.options.values()));
    }

    private static class JvmOptionsImpl
    implements JvmOptions,
    Serializable {
        private final List<JvmOption> args;

        private JvmOptionsImpl(List<JvmOption> args) {
            this.args = args;
        }

        @Override
        public Collection<JvmOption> asCollection() {
            return this.args;
        }
    }
}

