/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import io.quarkus.arc.deployment.devconsole.DevDecoratorInfo;
import io.quarkus.arc.deployment.devconsole.DevInterceptorInfo;
import io.quarkus.arc.deployment.devconsole.DevObserverInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DevBeanInfos {
    private final List<DevBeanInfo> beans = new ArrayList<DevBeanInfo>();
    private final List<DevBeanInfo> removedBeans = new ArrayList<DevBeanInfo>();
    private final List<DevObserverInfo> observers = new ArrayList<DevObserverInfo>();
    private final List<DevInterceptorInfo> interceptors = new ArrayList<DevInterceptorInfo>();
    private final List<DevInterceptorInfo> removedInterceptors = new ArrayList<DevInterceptorInfo>();
    private final List<DevDecoratorInfo> decorators = new ArrayList<DevDecoratorInfo>();
    private final List<DevDecoratorInfo> removedDecorators = new ArrayList<DevDecoratorInfo>();

    public List<DevBeanInfo> getRemovedBeans() {
        return this.removedBeans;
    }

    public List<DevBeanInfo> getBeans() {
        return this.beans;
    }

    public List<DevObserverInfo> getObservers() {
        return this.observers;
    }

    public List<DevInterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    public List<DevDecoratorInfo> getDecorators() {
        return this.decorators;
    }

    public List<DevInterceptorInfo> getRemovedInterceptors() {
        return this.removedInterceptors;
    }

    public List<DevDecoratorInfo> getRemovedDecorators() {
        return this.removedDecorators;
    }

    public DevInterceptorInfo getInterceptor(String id) {
        for (DevInterceptorInfo interceptor : this.interceptors) {
            if (!interceptor.getId().equals(id)) continue;
            return interceptor;
        }
        return null;
    }

    public int getRemovedComponents() {
        return this.removedBeans.size() + this.removedInterceptors.size() + this.removedDecorators.size();
    }

    void addBean(DevBeanInfo beanInfo) {
        this.beans.add(beanInfo);
    }

    void addRemovedBean(DevBeanInfo beanInfo) {
        this.removedBeans.add(beanInfo);
    }

    void addObserver(DevObserverInfo observer) {
        this.observers.add(observer);
    }

    void addInterceptor(DevInterceptorInfo interceptor) {
        this.interceptors.add(interceptor);
    }

    void addRemovedInterceptor(DevInterceptorInfo interceptor) {
        this.removedInterceptors.add(interceptor);
    }

    void addDecorator(DevDecoratorInfo decorator) {
        this.decorators.add(decorator);
    }

    void addRemovedDecorator(DevDecoratorInfo decorator) {
        this.removedDecorators.add(decorator);
    }

    void sort() {
        Collections.sort(this.beans);
        Collections.sort(this.removedBeans);
        Collections.sort(this.observers);
        Collections.sort(this.interceptors);
        Collections.sort(this.decorators);
        Collections.sort(this.removedDecorators);
        Collections.sort(this.removedInterceptors);
    }
}

