/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.ConfigBuildStep;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ArrayListFactory;
import io.quarkus.runtime.configuration.HashSetFactory;
import io.smallrye.config.SmallRyeConfig;
import java.util.Collection;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

final class ConfigPropertiesUtil {
    static final String PACKAGE_TO_PLACE_GENERATED_CLASSES = "io.quarkus.arc.runtime.config";

    private ConfigPropertiesUtil() {
    }

    static ResultHandle createReadMandatoryValueAndConvertIfNeeded(String propertyName, Type resultType, DotName declaringClass, BytecodeCreator bytecodeCreator, ResultHandle config) {
        if (ConfigPropertiesUtil.isMap(resultType)) {
            throw new DeploymentException("Using a Map is not supported for classes annotated with '@ConfigProperties'. Consider using https://quarkus.io/guides/config-mappings instead.");
        }
        if (ConfigPropertiesUtil.isCollection(resultType)) {
            ResultHandle smallryeConfig = bytecodeCreator.checkCast(config, SmallRyeConfig.class);
            Class factoryToUse = DotNames.SET.equals((Object)resultType.name()) ? HashSetFactory.class : ArrayListFactory.class;
            ResultHandle collectionFactory = bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(factoryToUse, (String)"getInstance", factoryToUse, (Class[])new Class[0]), new ResultHandle[0]);
            return bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValues", Collection.class, (Class[])new Class[]{String.class, Class.class, IntFunction.class}), smallryeConfig, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(ConfigPropertiesUtil.determineSingleGenericType(resultType, declaringClass).name().toString()), collectionFactory});
        }
        return bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(resultType.name().toString())});
    }

    static ReadOptionalResponse createReadOptionalValueAndConvertIfNeeded(String propertyName, Type resultType, DotName declaringClass, BytecodeCreator bytecodeCreator, ResultHandle config) {
        ResultHandle optionalValue;
        if (ConfigPropertiesUtil.isMap(resultType)) {
            throw new DeploymentException("Using a Map is not supported for classes annotated with '@ConfigProperties'. Consider using https://quarkus.io/guides/config-mappings instead.");
        }
        if (ConfigPropertiesUtil.isCollection(resultType)) {
            ResultHandle smallryeConfig = bytecodeCreator.checkCast(config, SmallRyeConfig.class);
            Class factoryToUse = DotNames.SET.equals((Object)resultType.name()) ? HashSetFactory.class : ArrayListFactory.class;
            ResultHandle collectionFactory = bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(factoryToUse, (String)"getInstance", factoryToUse, (Class[])new Class[0]), new ResultHandle[0]);
            optionalValue = bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getOptionalValues", Optional.class, (Class[])new Class[]{String.class, Class.class, IntFunction.class}), smallryeConfig, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(ConfigPropertiesUtil.determineSingleGenericType(resultType, declaringClass).name().toString()), collectionFactory});
        } else {
            optionalValue = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(resultType.name().toString())});
        }
        ResultHandle isPresent = bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]), optionalValue, new ResultHandle[0]);
        BranchResult isPresentBranch = bytecodeCreator.ifNonZero(isPresent);
        BytecodeCreator isPresentTrue = isPresentBranch.trueBranch();
        ResultHandle value = isPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"get", Object.class, (Class[])new Class[0]), optionalValue, new ResultHandle[0]);
        return new ReadOptionalResponse(value, isPresentTrue, isPresentBranch.falseBranch());
    }

    public static boolean isListOfObject(Type type) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (!DotNames.LIST.equals((Object)parameterizedType.name())) {
            return false;
        }
        if (parameterizedType.arguments().size() != 1) {
            return false;
        }
        return !((Type)parameterizedType.arguments().get(0)).name().toString().startsWith("java");
    }

    private static boolean isCollection(Type resultType) {
        return DotNames.COLLECTION.equals((Object)resultType.name()) || DotNames.LIST.equals((Object)resultType.name()) || DotNames.SET.equals((Object)resultType.name());
    }

    private static boolean isMap(Type resultType) {
        return DotNames.MAP.equals((Object)resultType.name()) || DotNames.HASH_MAP.equals((Object)resultType.name());
    }

    static Type determineSingleGenericType(Type type, DotName declaringClass) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalArgumentException("Type " + type.name().toString() + " which is used in class " + declaringClass + " must define a generic argument");
        }
        ParameterizedType parameterizedType = type.asParameterizedType();
        if (parameterizedType.arguments().size() != 1) {
            throw new IllegalArgumentException("Type " + type.name().toString() + " which is used in class " + declaringClass + " must define a single generic argument");
        }
        return (Type)type.asParameterizedType().arguments().get(0);
    }

    static void registerImplicitConverter(Type type, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (!ConfigBuildStep.isHandledByProducers(type) && type.kind() != Type.Kind.ARRAY) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
        }
    }

    static class ReadOptionalResponse {
        private final ResultHandle value;
        private final BytecodeCreator isPresentTrue;
        private final BytecodeCreator isPresentFalse;

        ReadOptionalResponse(ResultHandle value, BytecodeCreator isPresentTrue, BytecodeCreator isPresentFalse) {
            this.value = value;
            this.isPresentTrue = isPresentTrue;
            this.isPresentFalse = isPresentFalse;
        }

        public ResultHandle getValue() {
            return this.value;
        }

        public BytecodeCreator getIsPresentTrue() {
            return this.isPresentTrue;
        }

        public BytecodeCreator getIsPresentFalse() {
            return this.isPresentFalse;
        }
    }
}

