/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.AggregatedDataSourceBuildTimeConfigBuildItem;
import io.quarkus.agroal.deployment.AgroalDataSourceBuildUtil;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.AgroalOpenTelemetryWrapper;
import io.quarkus.agroal.runtime.AgroalRecorder;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.JdbcDriver;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.OpenTelemetrySdkBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.narayana.jta.deployment.NarayanaInitBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.sql.XADataSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final String OPEN_TELEMETRY_DRIVER = "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver";
    private static final DotName DATA_SOURCE = DotName.createSimple((String)javax.sql.DataSource.class.getName());
    private static final DotName AGROAL_DATA_SOURCE = DotName.createSimple((String)AgroalDataSource.class.getName());

    AgroalProcessor() {
    }

    @BuildStep
    void agroal(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.AGROAL));
    }

    @BuildStep
    void build(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, List<JdbcDriverBuildItem> jdbcDriverBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ServiceProviderBuildItem> service, Capabilities capabilities, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if (dataSourcesBuildTimeConfig.driver().isPresent() || dataSourcesBuildTimeConfig.url().isPresent()) {
            throw new ConfigurationException("quarkus.datasource.url and quarkus.datasource.driver have been deprecated in Quarkus 1.3 and removed in 1.9. Please use the new datasource configuration as explained in https://quarkus.io/guides/datasource.");
        }
        List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedDataSourceBuildTimeConfigs = this.getAggregatedConfigBuildItems(dataSourcesBuildTimeConfig, dataSourcesJdbcBuildTimeConfig, curateOutcomeBuildItem, jdbcDriverBuildItems, defaultDbKinds);
        if (aggregatedDataSourceBuildTimeConfigs.isEmpty()) {
            log.warn((Object)"The Agroal dependency is present but no JDBC datasources have been defined.");
            return;
        }
        boolean otelJdbcInstrumentationActive = false;
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedDataSourceBuildTimeConfigs) {
            AgroalProcessor.validateBuildTimeConfig(aggregatedDataSourceBuildTimeConfig);
            if (aggregatedDataSourceBuildTimeConfig.getJdbcConfig().telemetry()) {
                otelJdbcInstrumentationActive = true;
            }
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass()}).methods().build());
            aggregatedConfig.produce((BuildItem)aggregatedDataSourceBuildTimeConfig);
        }
        if (otelJdbcInstrumentationActive && capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(AgroalOpenTelemetryWrapper.class).setDefaultScope(DotNames.SINGLETON).build());
        }
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        service.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)Driver.class.getName()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}).build());
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.AGROAL.getName()));
    }

    private static void validateBuildTimeConfig(AggregatedDataSourceBuildTimeConfigBuildItem aggregatedConfig) {
        Class<?> driver;
        DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig = aggregatedConfig.getJdbcConfig();
        String fullDataSourceName = aggregatedConfig.isDefault() ? "default datasource" : "datasource named '" + aggregatedConfig.getName() + "'";
        String driverName = aggregatedConfig.getResolvedDriverClass();
        try {
            driver = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to load the datasource driver " + driverName + " for the " + fullDataSourceName, (Throwable)e);
        }
        if (jdbcBuildTimeConfig.transactions() == TransactionIntegration.XA) {
            if (!XADataSource.class.isAssignableFrom(driver)) {
                throw new ConfigurationException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the " + fullDataSourceName + ": either disable XA or switch the driver to an XADataSource");
            }
        } else if (driver != null && !javax.sql.DataSource.class.isAssignableFrom(driver) && !Driver.class.isAssignableFrom(driver)) {
            if (aggregatedConfig.isDefault()) {
                throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the default datasource; please either set 'quarkus.datasource.jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
            }
            throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the datasource named '" + fullDataSourceName + "'; please either set 'quarkus.datasource." + fullDataSourceName + ".jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
        }
    }

    private AgroalDataSourceSupport getDataSourceSupport(List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities) {
        HashMap<String, AgroalDataSourceSupport.Entry> dataSourceSupportEntries = new HashMap<String, AgroalDataSourceSupport.Entry>();
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedBuildTimeConfigBuildItems) {
            String dataSourceName = aggregatedDataSourceBuildTimeConfig.getName();
            dataSourceSupportEntries.put(dataSourceName, new AgroalDataSourceSupport.Entry(dataSourceName, aggregatedDataSourceBuildTimeConfig.getDbKind(), aggregatedDataSourceBuildTimeConfig.getDataSourceConfig().dbVersion(), aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass(), aggregatedDataSourceBuildTimeConfig.isDefault()));
        }
        return new AgroalDataSourceSupport(sslNativeConfig.isExplicitlyDisabled(), capabilities.isPresent("io.quarkus.metrics"), dataSourceSupportEntries);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateDataSourceSupportBean(AgroalRecorder recorder, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JdbcDriver.class}));
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DataSources.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DataSource.class).build());
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{AgroalPoolInterceptor.class}));
        AgroalDataSourceSupport agroalDataSourceSupport = this.getDataSourceSupport(aggregatedBuildTimeConfigBuildItems, sslNativeConfig, capabilities);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(AgroalDataSourceSupport.class).supplier(recorder.dataSourceSupportSupplier(agroalDataSourceSupport)).scope(Singleton.class)).unremovable()).setRuntimeInit().done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=NarayanaInitBuildItem.class)
    void generateDataSourceBeans(AgroalRecorder recorder, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, Optional<OpenTelemetrySdkBuildItem> openTelemetrySdkBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<JdbcDataSourceBuildItem> jdbcDataSource) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedBuildTimeConfigBuildItem : aggregatedBuildTimeConfigBuildItems) {
            String dataSourceName = aggregatedBuildTimeConfigBuildItem.getName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(AgroalDataSource.class).addType(DATA_SOURCE)).addType(AGROAL_DATA_SOURCE)).scope(ApplicationScoped.class)).qualifiers(AgroalDataSourceBuildUtil.qualifiers(dataSourceName))).setRuntimeInit().unremovable()).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(DataSources.class)), new AnnotationInstance[0])).startup()).checkActive(recorder.agroalDataSourceCheckActiveSupplier(dataSourceName)).createWith(recorder.agroalDataSourceSupplier(dataSourceName, dataSourcesRuntimeConfig, OpenTelemetrySdkBuildItem.isOtelSdkEnabled(openTelemetrySdkBuildItem))).destroyer(BeanDestroyer.AutoCloseableDestroyer.class);
            if (!DataSourceUtil.isDefault((String)dataSourceName)) {
                configurator.name(dataSourceName);
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
            jdbcDataSource.produce((BuildItem)new JdbcDataSourceBuildItem(dataSourceName, aggregatedBuildTimeConfigBuildItem.getDbKind(), aggregatedBuildTimeConfigBuildItem.getDataSourceConfig().dbVersion(), aggregatedBuildTimeConfigBuildItem.getJdbcConfig().transactions() != TransactionIntegration.DISABLED, aggregatedBuildTimeConfigBuildItem.isDefault()));
        }
    }

    private List<AggregatedDataSourceBuildTimeConfigBuildItem> getAggregatedConfigBuildItems(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<JdbcDriverBuildItem> jdbcDriverBuildItems, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds) {
        ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem> dataSources = new ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem>();
        for (Map.Entry entry : dataSourcesBuildTimeConfig.dataSources().entrySet()) {
            DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig = ((DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig)dataSourcesJdbcBuildTimeConfig.dataSources().get(entry.getKey())).jdbc();
            if (!jdbcBuildTimeConfig.enabled()) continue;
            boolean enableImplicitResolution = DataSourceUtil.isDefault((String)((String)entry.getKey())) ? ((DataSourceBuildTimeConfig)entry.getValue()).devservices().enabled().orElse(!dataSourcesBuildTimeConfig.hasNamedDataSources()) : true;
            Optional effectiveDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)((DataSourceBuildTimeConfig)entry.getValue()).dbKind(), defaultDbKinds, (boolean)enableImplicitResolution, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            if (!effectiveDbKind.isPresent()) continue;
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem((String)entry.getKey(), (DataSourceBuildTimeConfig)entry.getValue(), jdbcBuildTimeConfig, (String)effectiveDbKind.get(), this.resolveDriver((String)entry.getKey(), (String)effectiveDbKind.get(), jdbcBuildTimeConfig, jdbcDriverBuildItems)));
        }
        return dataSources;
    }

    private String resolveDriver(String dataSourceName, String dbKind, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, List<JdbcDriverBuildItem> jdbcDriverBuildItems) {
        if (dataSourceJdbcBuildTimeConfig.driver().isPresent()) {
            return (String)dataSourceJdbcBuildTimeConfig.driver().get();
        }
        Optional<JdbcDriverBuildItem> matchingJdbcDriver = jdbcDriverBuildItems.stream().filter(i -> dbKind.equals(i.getDbKind())).findFirst();
        if (matchingJdbcDriver.isPresent()) {
            if (TransactionIntegration.XA == dataSourceJdbcBuildTimeConfig.transactions()) {
                if (matchingJdbcDriver.get().getDriverXAClass().isPresent()) {
                    return (String)matchingJdbcDriver.get().getDriverXAClass().get();
                }
            } else {
                return matchingJdbcDriver.get().getDriverClass();
            }
        }
        throw new ConfigurationException(String.format("Unable to find a JDBC driver corresponding to the database kind '%s' for the %s (available: '%s'). Check if it's a typo, otherwise provide a suitable JDBC driver extension, define the driver manually, or disable the JDBC datasource by adding '%s=false' to your configuration if you don't need it.", dbKind, DataSourceUtil.isDefault((String)dataSourceName) ? "default datasource" : "datasource '" + dataSourceName + "'", jdbcDriverBuildItems.stream().map(JdbcDriverBuildItem::getDbKind).collect(Collectors.joining("','")), DataSourceUtil.dataSourcePropertyKey((String)dataSourceName, (String)"jdbc")));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(Capabilities capabilities, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.health")) {
            return new HealthBuildItem("io.quarkus.agroal.runtime.health.DataSourceHealthCheck", dataSourcesBuildTimeConfig.healthEnabled());
        }
        return null;
    }

    @BuildStep
    void registerRowSetSupport(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleProducer, BuildProducer<NativeImageResourceBuildItem> nativeResourceProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        resourceBundleProducer.produce((BuildItem)new NativeImageResourceBundleBuildItem("com.sun.rowset.RowSetResourceBundle"));
        nativeResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"javax/sql/rowset/rowset.properties"}));
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.sun.rowset.providers.RIOptimisticProvider", "com.sun.rowset.providers.RIXMLProvider"}).build());
    }

    @BuildStep
    void reduceLogging(BuildProducer<LogCategoryBuildItem> logCategories) {
        logCategories.produce((BuildItem)new LogCategoryBuildItem("io.agroal.pool", Level.WARNING));
    }
}

