/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.SimpleTyped;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.StaticFieldVarImpl;
import java.lang.constant.ClassDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expr
extends SimpleTyped {
    @Override
    public ClassDesc type();

    public GenericType genericType();

    public boolean hasGenericType();

    public Assignable elem(Expr var1);

    default public Assignable elem(Integer index) {
        return this.elem(Const.of(index));
    }

    default public Assignable elem(int index) {
        return this.elem(Const.of(index));
    }

    public Expr length();

    public InstanceFieldVar field(FieldDesc var1);

    public InstanceFieldVar field(FieldDesc var1, GenericType var2);

    default public InstanceFieldVar field(ClassDesc owner, String name, ClassDesc type) {
        return this.field(FieldDesc.of(owner, name, type));
    }

    default public InstanceFieldVar field(ClassDesc owner, String name, GenericType type) {
        return this.field(FieldDesc.of(owner, name, type.desc()), type);
    }

    public static StaticFieldVar staticField(FieldDesc desc) {
        return new StaticFieldVarImpl(desc, null);
    }

    public static StaticFieldVar staticField(FieldDesc desc, GenericType genericType) {
        if (!desc.type().equals(genericType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match field type %s".formatted(genericType, desc.type()));
        }
        return new StaticFieldVarImpl(desc, genericType);
    }
}

