/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.vault.runtime.Base64StringDeserializer;
import io.quarkus.vault.runtime.Base64StringSerializer;
import io.quarkus.vault.runtime.StringHelper;
import java.util.Base64;

@JsonSerialize(using=Base64StringSerializer.class)
@JsonDeserialize(using=Base64StringDeserializer.class)
public class Base64String {
    private String value;

    public static byte[] toBytes(String s) {
        return Base64.getDecoder().decode(s);
    }

    public static Base64String from(String s) {
        return s == null ? null : new Base64String(Base64.getEncoder().encodeToString(StringHelper.stringToBytes(s)));
    }

    public static Base64String from(byte[] bytes) {
        return bytes == null ? null : new Base64String(Base64.getEncoder().encodeToString(bytes));
    }

    public Base64String(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] decodeAsBytes() {
        return Base64String.toBytes(this.value);
    }

    public String decodeAsString() {
        return StringHelper.bytesToString(this.decodeAsBytes());
    }

    public String toString() {
        return this.value;
    }
}

