/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.Tool;
import io.quarkiverse.mcp.server.ToolCallException;
import io.quarkiverse.mcp.server.WrapBusinessError;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;

@Priority(value=1000)
@Interceptor
@WrapBusinessError
public class WrapBusinessErrorInterceptor {
    @AroundInvoke
    Object aroundInvoke(InvocationContext context) throws Exception {
        Object ret;
        try {
            ret = context.proceed();
        }
        catch (Throwable t2) {
            throw WrapBusinessErrorInterceptor.sneakyThrow(this.wrapIfNecessary(t2, context));
        }
        if (ret instanceof Uni) {
            Uni uni = (Uni)ret;
            return uni.onFailure().transform(t -> this.wrapIfNecessary((Throwable)t, context));
        }
        return ret;
    }

    private Throwable wrapIfNecessary(Throwable t, InvocationContext context) {
        if (context.getMethod().isAnnotationPresent(Tool.class) && this.matches(t, context)) {
            return new ToolCallException(t);
        }
        return t;
    }

    private boolean matches(Throwable t, InvocationContext context) {
        WrapBusinessError businessError = (WrapBusinessError)context.getInterceptorBinding(WrapBusinessError.class);
        for (Class<? extends Throwable> e : businessError.value()) {
            if (!e.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    private static <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

