/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.vertx.core.json.JsonObject;
import org.jboss.logging.Logger;

public class TrafficLogger {
    private static final Logger LOG = Logger.getLogger((String)"io.quarkus.mcp.server.traffic");
    private final int textPayloadLimit;

    public TrafficLogger(int textPayloadLimit) {
        this.textPayloadLimit = textPayloadLimit;
    }

    public void messageReceived(JsonObject message, McpConnection connection) {
        LOG.infof("MCP message received [%s]:\n\n%s", (Object)connection.id(), (Object)this.messageToString(message));
    }

    public void messageSent(JsonObject message, McpConnection connection) {
        LOG.infof("MCP message sent [%s]:\n\n%s", (Object)connection.id(), (Object)this.messageToString(message));
    }

    private String messageToString(JsonObject message) {
        String encoded = message.encodePrettily();
        if (encoded == null || encoded.isBlank()) {
            return "n/a";
        }
        if (this.textPayloadLimit < 0 || encoded.length() <= this.textPayloadLimit) {
            return encoded;
        }
        return encoded.substring(0, this.textPayloadLimit) + "...";
    }
}

