/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import io.quarkiverse.mcp.server.runtime.SchemaGeneratorConfigCustomizer;
import io.quarkiverse.mcp.server.runtime.config.McpServerSchemaGeneratorJakartaValidationRuntimeConfig;
import jakarta.enterprise.context.Dependent;
import java.util.ArrayList;

@Dependent
public class SchemaGeneratorConfigCustomizerJakartaValidation
implements SchemaGeneratorConfigCustomizer {
    private final McpServerSchemaGeneratorJakartaValidationRuntimeConfig config;

    public SchemaGeneratorConfigCustomizerJakartaValidation(McpServerSchemaGeneratorJakartaValidationRuntimeConfig config) {
        this.config = config;
    }

    @Override
    public void customize(SchemaGeneratorConfigBuilder builder) {
        if (this.config.enabled()) {
            JakartaValidationOption[] configuredOptions = this.getConfiguredOptions();
            Module jakartaValidationModule = this.createJakartaValidationModule(configuredOptions);
            builder.with(jakartaValidationModule);
        }
    }

    Module createJakartaValidationModule(JakartaValidationOption[] options) {
        return new JakartaValidationModule(options);
    }

    private JakartaValidationOption[] getConfiguredOptions() {
        ArrayList<JakartaValidationOption> options = new ArrayList<JakartaValidationOption>();
        if (this.config.notNullableFieldIsRequired()) {
            options.add(JakartaValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED);
        }
        if (this.config.notNullableMethodIsRequired()) {
            options.add(JakartaValidationOption.NOT_NULLABLE_METHOD_IS_REQUIRED);
        }
        if (this.config.preferIdnEmailFormat()) {
            options.add(JakartaValidationOption.PREFER_IDN_EMAIL_FORMAT);
        }
        if (this.config.includePatternExpressions()) {
            options.add(JakartaValidationOption.INCLUDE_PATTERN_EXPRESSIONS);
        }
        return (JakartaValidationOption[])options.toArray(JakartaValidationOption[]::new);
    }
}

