/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.ModelPreferences;
import io.quarkiverse.mcp.server.Sampling;
import io.quarkiverse.mcp.server.SamplingMessage;
import io.quarkiverse.mcp.server.SamplingRequest;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.SamplingRequestImpl;
import io.quarkiverse.mcp.server.runtime.Sender;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class SamplingImpl
implements Sampling {
    private final InitialRequest initialRequest;
    private final Sender sender;
    private final ResponseHandlers responseHandlers;
    private final Duration timeout;

    static SamplingImpl from(ArgumentProviders argProviders) {
        return new SamplingImpl(argProviders.connection().initialRequest(), argProviders.sender(), argProviders.responseHandlers(), argProviders.responseHandlers().getSamplingTimeout(argProviders.serverName()));
    }

    SamplingImpl(InitialRequest initialRequest, Sender sender, ResponseHandlers responseHandlers, Duration timeout) {
        this.initialRequest = initialRequest;
        this.sender = sender;
        this.responseHandlers = responseHandlers;
        this.timeout = timeout;
    }

    @Override
    public boolean isSupported() {
        return this.initialRequest.supportsSampling();
    }

    @Override
    public SamplingRequest.Builder requestBuilder() {
        if (!this.initialRequest.supportsSampling()) {
            throw new IllegalStateException("Client " + String.valueOf(this.initialRequest.implementation()) + " does not support the `sampling` capability");
        }
        return new SamplingRequestBuilder();
    }

    class SamplingRequestBuilder
    implements SamplingRequest.Builder {
        private Long maxTokens;
        private final List<SamplingMessage> messages = new ArrayList<SamplingMessage>();
        private BigDecimal temperature;
        private String systemPrompt;
        private SamplingRequest.IncludeContext includeContext;
        private ModelPreferences modelPreferences;
        private Map<String, Object> metadata;
        private List<String> stopSequences;
        private Duration timeout;

        SamplingRequestBuilder() {
            this.timeout = SamplingImpl.this.timeout;
        }

        @Override
        public SamplingRequest.Builder addMessage(SamplingMessage message) {
            this.messages.add(message);
            return this;
        }

        @Override
        public SamplingRequest.Builder setMaxTokens(long maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public SamplingRequest.Builder setTemperature(BigDecimal temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public SamplingRequest.Builder setSystemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        @Override
        public SamplingRequest.Builder setIncludeContext(SamplingRequest.IncludeContext includeContext) {
            this.includeContext = includeContext;
            return this;
        }

        @Override
        public SamplingRequest.Builder setModelPreferences(ModelPreferences modelPreferences) {
            this.modelPreferences = modelPreferences;
            return this;
        }

        @Override
        public SamplingRequest.Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public SamplingRequest.Builder setStopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public SamplingRequest.Builder setTimeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout);
            return this;
        }

        @Override
        public SamplingRequest build() {
            if (this.maxTokens == null) {
                throw new IllegalStateException("maxTokens must be set");
            }
            return new SamplingRequestImpl(this.maxTokens, List.copyOf(this.messages), this.temperature, this.systemPrompt, this.includeContext, this.modelPreferences, this.metadata, this.stopSequences, SamplingImpl.this.sender, SamplingImpl.this.responseHandlers, this.timeout);
        }
    }
}

