/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.Root;
import io.quarkiverse.mcp.server.Roots;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;

class RootsImpl
implements Roots {
    private static final Logger LOG = Logger.getLogger(Roots.class);
    private final InitialRequest initialRequest;
    private final Sender sender;
    private final ResponseHandlers responseHandlers;
    private final Duration timeout;

    static RootsImpl from(ArgumentProviders argProviders) {
        return new RootsImpl(argProviders.connection().initialRequest(), argProviders.sender(), argProviders.responseHandlers(), argProviders.responseHandlers().getRootsTimeout(argProviders.serverName()));
    }

    RootsImpl(InitialRequest initialRequest, Sender sender, ResponseHandlers responseHandlers, Duration timeout) {
        this.initialRequest = initialRequest;
        this.sender = sender;
        this.responseHandlers = responseHandlers;
        this.timeout = timeout;
    }

    @Override
    public boolean isSupported() {
        return this.initialRequest.supportsRoots();
    }

    @Override
    public Uni<List<Root>> list() {
        if (!this.initialRequest.supportsRoots()) {
            throw new IllegalStateException("Client " + String.valueOf(this.initialRequest.implementation()) + " does not support the `roots` capability");
        }
        AtomicLong id = new AtomicLong();
        Uni ret = Uni.createFrom().completionStage(() -> {
            CompletableFuture future = new CompletableFuture();
            Long requestId = this.responseHandlers.newRequest(m -> {
                JsonObject result = m.getJsonObject("result");
                JsonArray roots = result.getJsonArray("roots");
                ArrayList<Root> list = new ArrayList<Root>(roots.size());
                for (Object root : roots) {
                    if (!(root instanceof JsonObject)) continue;
                    JsonObject jo = (JsonObject)root;
                    list.add(new Root(jo.getString("name"), jo.getString("uri")));
                }
                future.complete(list);
            });
            id.set(requestId);
            this.sender.send(Messages.newRequest(requestId, "roots/list"));
            return future;
        });
        if (!this.timeout.isNegative() && !this.timeout.isZero()) {
            ret = ret.ifNoItem().after(this.timeout).fail().onFailure(TimeoutException.class).invoke(te -> {
                long requestId = id.get();
                if (requestId != 0L && this.responseHandlers.remove(requestId)) {
                    LOG.debugf("Response handler for %s removed due to timeout", requestId);
                }
            });
        }
        return ret;
    }
}

