/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Singleton
public class ResponseHandlers {
    private static final Logger LOG = Logger.getLogger(ResponseHandlers.class);
    private final ConcurrentMap<Long, ResponseHandler> handlers = new ConcurrentHashMap<Long, ResponseHandler>();
    private final AtomicLong idGenerator = new AtomicLong();
    private final McpServersRuntimeConfig config;

    ResponseHandlers(McpServersRuntimeConfig config) {
        this.config = config;
    }

    public boolean hasHandler(long id) {
        return this.handlers.containsKey(id);
    }

    Long nextId() {
        return this.idGenerator.incrementAndGet();
    }

    Long newRequest(Consumer<JsonObject> responseConsumer) {
        Long nextId = this.nextId();
        this.handlers.put(nextId, new ResponseHandler(Instant.now(), responseConsumer));
        return nextId;
    }

    boolean remove(long id) {
        if (this.handlers.remove(id) != null) {
            LOG.debugf("Removed response handler for %s", id);
            return true;
        }
        return false;
    }

    Future<Void> handleResponse(Object id, JsonObject message) {
        if (id == null) {
            LOG.debugf("Discard client response with no id: %s", (Object)message);
        } else {
            ResponseHandler handler = (ResponseHandler)this.handlers.remove(this.coerceResponseId(id));
            if (handler == null) {
                LOG.debugf("Handler not found - discard client response with id %s", id);
            } else {
                try {
                    handler.operation().accept(message);
                }
                catch (Throwable e) {
                    LOG.errorf(e, "Unable to process the response with id %s", id);
                    return Future.failedFuture((Throwable)e);
                }
            }
        }
        return Future.succeededFuture();
    }

    private Long coerceResponseId(Object id) {
        if (id instanceof Long) {
            Long longId = (Long)id;
            return longId;
        }
        if (id instanceof Integer) {
            Integer intId = (Integer)id;
            return intId.longValue();
        }
        if (id instanceof String) {
            String strId = (String)id;
            return Long.parseLong(strId);
        }
        throw new IllegalArgumentException("Unsupported response identifier: " + String.valueOf(id));
    }

    Duration getSamplingTimeout(String serverName) {
        return this.config.servers().get(serverName).sampling().defaultTimeout();
    }

    Duration getRootsTimeout(String serverName) {
        return this.config.servers().get(serverName).roots().defaultTimeout();
    }

    private record ResponseHandler(Instant creationTime, Consumer<JsonObject> operation) {
        public ResponseHandler {
            if (creationTime == null) {
                throw new IllegalArgumentException("creationTime must not be null");
            }
            if (operation == null) {
                throw new IllegalArgumentException("operation must not be null");
            }
        }
    }
}

