/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.RequestUri;
import io.quarkiverse.mcp.server.ResourceContentsEncoder;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.ResourceTemplateFilter;
import io.quarkiverse.mcp.server.ResourceTemplateManager;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.ProgressImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkus.arc.All;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ResourceTemplateManagerImpl
extends FeatureManagerBase<ResourceResponse, ResourceTemplateManager.ResourceTemplateInfo>
implements ResourceTemplateManager {
    private static final Logger LOG = Logger.getLogger(ResourceTemplateManagerImpl.class);
    final ConcurrentMap<String, ResourceTemplateMetadata> templates = new ConcurrentHashMap<String, ResourceTemplateMetadata>();
    final List<ResourceTemplateFilter> filters;

    ResourceTemplateManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers, @All List<ResourceTemplateFilter> filters) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        for (FeatureMetadata<ResourceResponse> fm : metadata.resourceTemplates()) {
            this.templates.put(fm.info().name(), new ResourceTemplateMetadata(ResourceTemplateManagerImpl.createMatcherFromUriTemplate(fm.info().uri()), new ResourceTemplateMethod(fm)));
        }
        this.filters = filters;
    }

    @Override
    Stream<ResourceTemplateManager.ResourceTemplateInfo> infos() {
        return this.templates.values().stream().map(ResourceTemplateMetadata::info);
    }

    @Override
    Stream<ResourceTemplateManager.ResourceTemplateInfo> filter(Stream<ResourceTemplateManager.ResourceTemplateInfo> infos, McpConnection connection) {
        return infos.filter(rt -> this.test((ResourceTemplateManager.ResourceTemplateInfo)rt, connection));
    }

    @Override
    public ResourceTemplateManager.ResourceTemplateInfo getResourceTemplate(String name) {
        ResourceTemplateMetadata metadata = (ResourceTemplateMetadata)this.templates.get(Objects.requireNonNull(name));
        return metadata != null ? metadata.info() : null;
    }

    @Override
    public ResourceTemplateManager.ResourceTemplateDefinition newResourceTemplate(String name) {
        if (this.templates.containsKey(name)) {
            throw this.resourceTemplateWithNameAlreadyExists(name);
        }
        return new ResourceTemplateDefinitionImpl(name);
    }

    @Override
    public ResourceTemplateManager.ResourceTemplateInfo removeResourceTemplate(String name) {
        AtomicReference removed = new AtomicReference();
        this.templates.computeIfPresent(name, (key, value) -> {
            if (!value.info().isMethod()) {
                removed.set(value.info);
                return null;
            }
            return value;
        });
        return (ResourceTemplateManager.ResourceTemplateInfo)removed.get();
    }

    private VariableMatcher getVariableMatcher(String name) {
        return ((ResourceTemplateMetadata)this.templates.get(name)).variableMatcher();
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<ResourceResponse> getInvoker(String id, McpRequest mcpRequest) {
        ResourceTemplateManager.ResourceTemplateInfo found = this.findMatching(id);
        if (found instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)found);
            if (this.matches(found, mcpRequest) && this.test(found, mcpRequest.connection())) {
                return fi;
            }
        }
        return null;
    }

    public ResourceTemplateManager.ResourceTemplateInfo findMatching(String uri) {
        for (ResourceTemplateMetadata t : this.templates.values()) {
            if (!t.variableMatcher().matches(uri)) continue;
            return t.info();
        }
        return null;
    }

    private boolean test(ResourceTemplateManager.ResourceTemplateInfo resourceTemplate, McpConnection connection) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (ResourceTemplateFilter filter : this.filters) {
            try {
                if (filter.test(resourceTemplate, connection)) continue;
                return false;
            }
            catch (RuntimeException e) {
                LOG.errorf((Throwable)e, "Unable to apply filter: %s", (Object)filter);
            }
        }
        return true;
    }

    IllegalArgumentException resourceTemplateWithNameAlreadyExists(String name) {
        return new IllegalArgumentException("A resource template with name [" + name + "] already exits");
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid resource uri: " + id, -32002);
    }

    @Override
    protected Object[] prepareArguments(FeatureMetadata<?> metadata, ArgumentProviders argProviders) throws McpException {
        Map<String, Object> matchedVariables = this.getVariableMatcher(metadata.info().name()).matchVariables(argProviders.uri()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).toString()));
        argProviders = new ArgumentProviders(matchedVariables, argProviders.connection(), argProviders.requestId(), argProviders.uri(), argProviders.sender(), argProviders.progressToken(), this.responseHandlers, argProviders.serverName());
        return super.prepareArguments(metadata, argProviders);
    }

    public static VariableMatcher createMatcherFromUriTemplate(String uriTemplate) {
        ArrayList<String> variables = new ArrayList<String>();
        Matcher m = Pattern.compile("\\{(\\w+)\\}").matcher(uriTemplate);
        StringBuilder uriRegex = new StringBuilder();
        while (m.find()) {
            variables.add(m.group(1));
            m.appendReplacement(uriRegex, "([^/]+)");
        }
        m.appendTail(uriRegex);
        return new VariableMatcher(Pattern.compile(uriRegex.toString()), variables);
    }

    @Override
    protected Object wrapResult(Object ret, FeatureMetadata<?> metadata, ArgumentProviders argProviders) {
        if (metadata.resultMapper() instanceof EncoderMapper) {
            if (ret instanceof Uni) {
                Uni uni = (Uni)ret;
                return uni.map(i -> {
                    if (i instanceof List) {
                        List list = (List)i;
                        return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
                    }
                    return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), i);
                });
            }
            if (ret instanceof List) {
                List list = (List)ret;
                return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
            }
            return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), ret);
        }
        return super.wrapResult(ret, metadata, argProviders);
    }

    record ResourceTemplateMetadata(VariableMatcher variableMatcher, ResourceTemplateManager.ResourceTemplateInfo info) {
    }

    public record VariableMatcher(Pattern pattern, List<String> variables) {
        boolean matches(String uri) {
            return this.pattern.matcher(uri).matches();
        }

        Map<String, String> matchVariables(String uri) {
            HashMap<String, String> ret = new HashMap<String, String>();
            Matcher m = this.pattern.matcher(uri);
            if (m.matches()) {
                for (int i = 0; i < m.groupCount(); ++i) {
                    ret.put(this.variables.get(i), m.group(i + 1));
                }
            }
            return ret;
        }
    }

    class ResourceTemplateMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<ResourceResponse>
    implements ResourceTemplateManager.ResourceTemplateInfo {
        private ResourceTemplateMethod(FeatureMetadata<ResourceResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String serverName() {
            return this.metadata.info().serverName();
        }

        @Override
        public String uriTemplate() {
            return this.metadata.info().uri();
        }

        @Override
        public String mimeType() {
            return this.metadata.info().mimeType();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public JsonObject asJson() {
            return this.metadata.asJson();
        }
    }

    class ResourceTemplateDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<ResourceTemplateManager.ResourceTemplateInfo, ResourceTemplateManager.ResourceTemplateArguments, ResourceResponse, ResourceTemplateDefinitionImpl>
    implements ResourceTemplateManager.ResourceTemplateDefinition {
        private String uriTemplate;
        private String mimeType;

        ResourceTemplateDefinitionImpl(String name) {
            super(name);
        }

        @Override
        public ResourceTemplateManager.ResourceTemplateDefinition setUriTemplate(String uriTemplate) {
            this.uriTemplate = Objects.requireNonNull(uriTemplate);
            return this;
        }

        @Override
        public ResourceTemplateManager.ResourceTemplateDefinition setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public ResourceTemplateManager.ResourceTemplateInfo register() {
            this.validate();
            ResourceTemplateDefinitionInfo ret = new ResourceTemplateDefinitionInfo(this.name, this.description, this.serverName, this.fun, this.asyncFun, this.runOnVirtualThread, this.uriTemplate, this.mimeType);
            VariableMatcher variableMatcher = ResourceTemplateManagerImpl.createMatcherFromUriTemplate(this.uriTemplate);
            ResourceTemplateMetadata existing = ResourceTemplateManagerImpl.this.templates.putIfAbsent(this.name, new ResourceTemplateMetadata(variableMatcher, ret));
            if (existing != null) {
                throw ResourceTemplateManagerImpl.this.resourceTemplateWithNameAlreadyExists(this.name);
            }
            return ret;
        }
    }

    class ResourceTemplateDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<ResourceTemplateManager.ResourceTemplateArguments, ResourceResponse>
    implements ResourceTemplateManager.ResourceTemplateInfo {
        private final String uriTemplate;
        private final String mimeType;

        private ResourceTemplateDefinitionInfo(String name, String description, String serverName, Function<ResourceTemplateManager.ResourceTemplateArguments, ResourceResponse> fun, Function<ResourceTemplateManager.ResourceTemplateArguments, Uni<ResourceResponse>> asyncFun, boolean runOnVirtualThread, String uri, String mimeType) {
            super(name, description, serverName, fun, asyncFun, runOnVirtualThread);
            this.uriTemplate = uri;
            this.mimeType = mimeType;
        }

        @Override
        public String uriTemplate() {
            return this.uriTemplate;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public JsonObject asJson() {
            return new JsonObject().put("name", (Object)this.name()).put("description", (Object)this.description()).put("uriTemplate", (Object)this.uriTemplate()).put("mimeType", (Object)this.mimeType());
        }

        @Override
        protected ResourceTemplateManager.ResourceTemplateArguments createArguments(ArgumentProviders argumentProviders) {
            Map<String, String> matchedVariables = ResourceTemplateManagerImpl.this.getVariableMatcher(this.name).matchVariables(argumentProviders.uri());
            return new ResourceTemplateManager.ResourceTemplateArguments(matchedVariables, argumentProviders.connection(), ResourceTemplateManagerImpl.this.log(Feature.RESOURCE_TEMPLATE.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()), new RequestUri(argumentProviders.uri()), ProgressImpl.from(argumentProviders), RootsImpl.from(argumentProviders), SamplingImpl.from(argumentProviders));
        }
    }
}

