/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.RequestUri;
import io.quarkiverse.mcp.server.ResourceContentsEncoder;
import io.quarkiverse.mcp.server.ResourceFilter;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ProgressImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkus.arc.All;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ResourceManagerImpl
extends FeatureManagerBase<ResourceResponse, ResourceManager.ResourceInfo>
implements ResourceManager {
    private static final Logger LOG = Logger.getLogger(ResourceManagerImpl.class);
    final ResourceTemplateManagerImpl resourceTemplateManager;
    final ConcurrentMap<String, ResourceManager.ResourceInfo> resources;
    final ConcurrentMap<String, List<String>> subscribers;
    final List<ResourceFilter> filters;

    ResourceManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ResourceTemplateManagerImpl resourceTemplateManager, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers, @All List<ResourceFilter> filters) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        this.resourceTemplateManager = resourceTemplateManager;
        this.resources = new ConcurrentHashMap<String, ResourceManager.ResourceInfo>();
        this.subscribers = new ConcurrentHashMap<String, List<String>>();
        for (FeatureMetadata<ResourceResponse> f : metadata.resources()) {
            this.resources.put(f.info().uri(), new ResourceMethod(f));
        }
        this.filters = filters;
    }

    @Override
    Stream<ResourceManager.ResourceInfo> infos() {
        return this.resources.values().stream();
    }

    @Override
    Stream<ResourceManager.ResourceInfo> filter(Stream<ResourceManager.ResourceInfo> infos, McpConnection connection) {
        return infos.filter(r -> this.test((ResourceManager.ResourceInfo)r, connection));
    }

    @Override
    public ResourceManager.ResourceInfo getResource(String uri) {
        return (ResourceManager.ResourceInfo)this.resources.get(Objects.requireNonNull(uri));
    }

    void subscribe(String uri, McpRequest mcpRequest) {
        ResourceManager.ResourceInfo info = this.getResource(uri);
        if (info == null || !this.matches(info, mcpRequest)) {
            throw this.notFound(uri);
        }
        CopyOnWriteArrayList<String> ids = new CopyOnWriteArrayList<String>();
        ids.add(mcpRequest.connection().id());
        this.subscribers.merge(uri, ids, (old, val) -> Stream.concat(old.stream(), val.stream()).collect(Collectors.toCollection(CopyOnWriteArrayList::new)));
    }

    void unsubscribe(String uri, String connectionId) {
        List ids = (List)this.subscribers.get(uri);
        if (ids != null) {
            ids.remove(connectionId);
        }
    }

    @Override
    public ResourceManager.ResourceDefinition newResource(String name) {
        for (ResourceManager.ResourceInfo resource : this.resources.values()) {
            if (!resource.name().equals(name)) continue;
            this.resourceWithNameAlreadyExists(name);
        }
        return new ResourceDefinitionImpl(name);
    }

    private void sendUpdateNotifications(String uri) {
        JsonObject updated = Messages.newNotification("notifications/resources/updated", new JsonObject().put("uri", (Object)uri));
        List ids = (List)this.subscribers.get(uri);
        if (ids != null) {
            for (String connectionId : ids) {
                McpConnectionBase connection = this.connectionManager.get(connectionId);
                if (connection != null) {
                    connection.send(updated);
                    continue;
                }
                this.unsubscribe(uri, connectionId);
            }
        }
    }

    IllegalArgumentException resourceWithNameAlreadyExists(String name) {
        return new IllegalArgumentException("A resource with name [" + name + "] already exits");
    }

    IllegalArgumentException resourceWithUriAlreadyExists(String uri) {
        return new IllegalArgumentException("A resource with uri [" + uri + "] already exits");
    }

    @Override
    public ResourceManager.ResourceInfo removeResource(String uri) {
        AtomicReference removed = new AtomicReference();
        this.resources.computeIfPresent(uri, (key, value) -> {
            if (!value.isMethod()) {
                removed.set(value);
                this.notifyConnections("notifications/resources/list_changed");
                return null;
            }
            return value;
        });
        return (ResourceManager.ResourceInfo)removed.get();
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<ResourceResponse> getInvoker(String id, McpRequest mcpRequest) {
        ResourceManager.ResourceInfo resource = (ResourceManager.ResourceInfo)this.resources.get(id);
        if (resource instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)resource);
            if (this.matches(resource, mcpRequest) && this.test(resource, mcpRequest.connection())) {
                return fi;
            }
        }
        return this.resourceTemplateManager.getInvoker(id, mcpRequest);
    }

    @Override
    protected Object wrapResult(Object ret, FeatureMetadata<?> metadata, ArgumentProviders argProviders) {
        if (metadata.resultMapper() instanceof EncoderMapper) {
            if (ret instanceof Uni) {
                Uni uni = (Uni)ret;
                return uni.map(i -> {
                    if (i instanceof List) {
                        List list = (List)i;
                        return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
                    }
                    return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), i);
                });
            }
            if (ret instanceof List) {
                List list = (List)ret;
                return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
            }
            return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), ret);
        }
        return super.wrapResult(ret, metadata, argProviders);
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid resource uri: " + id, -32002);
    }

    private boolean test(ResourceManager.ResourceInfo resource, McpConnection connection) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (ResourceFilter filter : this.filters) {
            try {
                if (filter.test(resource, connection)) continue;
                return false;
            }
            catch (RuntimeException e) {
                LOG.errorf((Throwable)e, "Unable to apply filter: %s", (Object)filter);
            }
        }
        return true;
    }

    class ResourceMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<ResourceResponse>
    implements ResourceManager.ResourceInfo {
        private ResourceMethod(FeatureMetadata<ResourceResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String serverName() {
            return this.metadata.info().serverName();
        }

        @Override
        public String uri() {
            return this.metadata.info().uri();
        }

        @Override
        public String mimeType() {
            return this.metadata.info().mimeType();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public JsonObject asJson() {
            return this.metadata.asJson();
        }

        @Override
        public void sendUpdateAndForget() {
            ResourceManagerImpl.this.sendUpdateNotifications(this.uri());
        }
    }

    class ResourceDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<ResourceManager.ResourceInfo, ResourceManager.ResourceArguments, ResourceResponse, ResourceDefinitionImpl>
    implements ResourceManager.ResourceDefinition {
        private String uri;
        private String mimeType;

        ResourceDefinitionImpl(String name) {
            super(name);
        }

        @Override
        public ResourceManager.ResourceDefinition setUri(String uri) {
            if (ResourceManagerImpl.this.resources.containsKey(uri)) {
                throw ResourceManagerImpl.this.resourceWithUriAlreadyExists(uri);
            }
            this.uri = Objects.requireNonNull(uri);
            return this;
        }

        @Override
        public ResourceManager.ResourceDefinition setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public ResourceManager.ResourceInfo register() {
            this.validate();
            ResourceDefinitionInfo ret = new ResourceDefinitionInfo(this.name, this.description, this.serverName, this.fun, this.asyncFun, this.runOnVirtualThread, this.uri, this.mimeType);
            ResourceManager.ResourceInfo existing = ResourceManagerImpl.this.resources.putIfAbsent(this.uri, ret);
            if (existing != null) {
                throw ResourceManagerImpl.this.resourceWithUriAlreadyExists(this.uri);
            }
            ResourceManagerImpl.this.notifyConnections("notifications/resources/list_changed");
            return ret;
        }
    }

    class ResourceDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<ResourceManager.ResourceArguments, ResourceResponse>
    implements ResourceManager.ResourceInfo {
        private final String uri;
        private final String mimeType;

        private ResourceDefinitionInfo(String name, String description, String serverName, Function<ResourceManager.ResourceArguments, ResourceResponse> fun, Function<ResourceManager.ResourceArguments, Uni<ResourceResponse>> asyncFun, boolean runOnVirtualThread, String uri, String mimeType) {
            super(name, description, serverName, fun, asyncFun, runOnVirtualThread);
            this.uri = uri;
            this.mimeType = mimeType;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public JsonObject asJson() {
            JsonObject ret = new JsonObject().put("name", (Object)this.name()).put("description", (Object)this.description()).put("uri", (Object)this.uri);
            if (this.mimeType != null) {
                ret.put("mimeType", (Object)this.mimeType);
            }
            return ret;
        }

        @Override
        protected ResourceManager.ResourceArguments createArguments(ArgumentProviders argumentProviders) {
            return new ResourceManager.ResourceArguments(argumentProviders.connection(), ResourceManagerImpl.this.log(Feature.RESOURCE.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()), new RequestUri(argumentProviders.uri()), ProgressImpl.from(argumentProviders), RootsImpl.from(argumentProviders), SamplingImpl.from(argumentProviders));
        }

        @Override
        public void sendUpdateAndForget() {
            ResourceManagerImpl.this.sendUpdateNotifications(this.uri());
        }
    }
}

