/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;

class PromptMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(PromptMessageHandler.class);
    private final PromptManagerImpl manager;
    private final McpServersRuntimeConfig config;

    PromptMessageHandler(PromptManagerImpl manager, McpServersRuntimeConfig config) {
        this.manager = Objects.requireNonNull(manager);
        this.config = config;
    }

    Future<Void> promptsList(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, mcpRequest.sender());
        if (cursor == null) {
            return Future.succeededFuture();
        }
        LOG.debugf("List prompts [id: %s, cursor: %s]", id, (Object)cursor);
        McpServerRuntimeConfig serverConfig = this.config.servers().get(mcpRequest.serverName());
        if (serverConfig == null) {
            throw new IllegalStateException("Server config not found: " + mcpRequest.serverName());
        }
        int pageSize = serverConfig.prompts().pageSize();
        JsonArray prompts = new JsonArray();
        JsonObject result = new JsonObject().put("prompts", (Object)prompts);
        Page page = this.manager.fetchPage(mcpRequest, cursor, pageSize);
        for (PromptManager.PromptInfo info : page) {
            prompts.add((Object)info.asJson());
        }
        if (page.hasNextCursor()) {
            PromptManager.PromptInfo last = (PromptManager.PromptInfo)page.lastInfo();
            result.put("nextCursor", (Object)Cursor.encode(last.createdAt(), last.name()));
        }
        return mcpRequest.sender().sendResult(id, result);
    }

    Future<Void> promptsGet(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String promptName = params.getString("name");
        LOG.debugf("Get prompt %s [id: %s]", (Object)promptName, id);
        Map args = params.containsKey("arguments") ? params.getJsonObject("arguments").getMap() : Map.of();
        ArgumentProviders argProviders = new ArgumentProviders(args, mcpRequest.connection(), id, null, mcpRequest.sender(), Messages.getProgressToken(message), this.manager.responseHandlers, mcpRequest.serverName());
        try {
            Future fu = this.manager.execute(promptName, new FeatureManagerBase.FeatureExecutionContext(argProviders, mcpRequest));
            return fu.compose(promptResponse -> {
                JsonObject result = new JsonObject();
                if (promptResponse.description() != null) {
                    result.put("description", (Object)promptResponse.description());
                }
                result.put("messages", promptResponse.messages());
                return mcpRequest.sender().sendResult(id, result);
            }, cause -> this.handleFailure(id, mcpRequest.sender(), mcpRequest.connection(), (Throwable)cause, LOG, "Unable to obtain prompt %s", promptName));
        }
        catch (McpException e) {
            return mcpRequest.sender().sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

