/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.PromptFilter;
import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.ProgressImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkus.arc.All;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class PromptManagerImpl
extends FeatureManagerBase<PromptResponse, PromptManager.PromptInfo>
implements PromptManager {
    private static final Logger LOG = Logger.getLogger(PromptManagerImpl.class);
    final ConcurrentMap<String, PromptManager.PromptInfo> prompts = new ConcurrentHashMap<String, PromptManager.PromptInfo>();
    final List<PromptFilter> filters;

    PromptManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers, @All List<PromptFilter> filters) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        for (FeatureMetadata<PromptResponse> f : metadata.prompts()) {
            this.prompts.put(f.info().name(), new PromptMethod(f));
        }
        this.filters = filters;
    }

    @Override
    Stream<PromptManager.PromptInfo> infos() {
        return this.prompts.values().stream();
    }

    @Override
    Stream<PromptManager.PromptInfo> filter(Stream<PromptManager.PromptInfo> infos, McpConnection connection) {
        return infos.filter(p -> this.test((PromptManager.PromptInfo)p, connection));
    }

    @Override
    public PromptManager.PromptInfo getPrompt(String name) {
        return (PromptManager.PromptInfo)this.prompts.get(Objects.requireNonNull(name));
    }

    @Override
    public PromptManager.PromptDefinition newPrompt(String name) {
        if (this.prompts.containsKey(name)) {
            throw this.promptWithNameAlreadyExists(name);
        }
        return new PromptDefinitionImpl(name);
    }

    @Override
    public PromptManager.PromptInfo removePrompt(String name) {
        AtomicReference removed = new AtomicReference();
        this.prompts.computeIfPresent(name, (key, value) -> {
            if (!value.isMethod()) {
                removed.set(value);
                this.notifyConnections("notifications/prompts/list_changed");
                return null;
            }
            return value;
        });
        return (PromptManager.PromptInfo)removed.get();
    }

    IllegalArgumentException promptWithNameAlreadyExists(String name) {
        return new IllegalArgumentException("A prompt with name [" + name + "] already exits");
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid prompt name: " + id, -32602);
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<PromptResponse> getInvoker(String id, McpRequest mcpRequest) {
        PromptManager.PromptInfo prompt = (PromptManager.PromptInfo)this.prompts.get(id);
        if (prompt instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)prompt);
            if (this.matches(prompt, mcpRequest) && this.test(prompt, mcpRequest.connection())) {
                return fi;
            }
        }
        return null;
    }

    private boolean test(PromptManager.PromptInfo prompt, McpConnection connection) {
        if (this.filters.isEmpty() || connection == null) {
            return true;
        }
        for (PromptFilter filter : this.filters) {
            try {
                if (filter.test(prompt, connection)) continue;
                return false;
            }
            catch (RuntimeException e) {
                LOG.errorf((Throwable)e, "Unable to apply filter: %s", (Object)filter);
            }
        }
        return true;
    }

    class PromptMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<PromptResponse>
    implements PromptManager.PromptInfo {
        private PromptMethod(FeatureMetadata<PromptResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String serverName() {
            return this.metadata.info().serverName();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public List<PromptManager.PromptArgument> arguments() {
            return this.metadata.info().serializedArguments().stream().map(a -> new PromptManager.PromptArgument(a.name(), a.description(), a.required(), a.defaultValue())).toList();
        }

        @Override
        public JsonObject asJson() {
            return this.metadata.asJson();
        }
    }

    class PromptDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<PromptManager.PromptInfo, PromptManager.PromptArguments, PromptResponse, PromptDefinitionImpl>
    implements PromptManager.PromptDefinition {
        private final List<PromptManager.PromptArgument> arguments;

        PromptDefinitionImpl(String name) {
            super(name);
            this.arguments = new ArrayList<PromptManager.PromptArgument>();
        }

        @Override
        public PromptManager.PromptDefinition addArgument(String name, String description, boolean required, String defaultValue) {
            this.arguments.add(new PromptManager.PromptArgument(name, description, required, defaultValue));
            return this;
        }

        @Override
        public PromptManager.PromptInfo register() {
            this.validate();
            PromptDefinitionInfo ret = new PromptDefinitionInfo(this.name, this.description, this.serverName, this.fun, this.asyncFun, this.runOnVirtualThread, this.arguments);
            PromptManager.PromptInfo existing = PromptManagerImpl.this.prompts.putIfAbsent(this.name, ret);
            if (existing != null) {
                throw PromptManagerImpl.this.promptWithNameAlreadyExists(this.name);
            }
            PromptManagerImpl.this.notifyConnections("notifications/prompts/list_changed");
            return ret;
        }
    }

    class PromptDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<PromptManager.PromptArguments, PromptResponse>
    implements PromptManager.PromptInfo {
        private final List<PromptManager.PromptArgument> arguments;

        private PromptDefinitionInfo(String name, String description, String serverName, Function<PromptManager.PromptArguments, PromptResponse> fun, Function<PromptManager.PromptArguments, Uni<PromptResponse>> asyncFun, boolean runOnVirtualThread, List<PromptManager.PromptArgument> arguments) {
            super(name, description, serverName, fun, asyncFun, runOnVirtualThread);
            this.arguments = List.copyOf(arguments);
        }

        @Override
        public List<PromptManager.PromptArgument> arguments() {
            return this.arguments;
        }

        @Override
        protected PromptManager.PromptArguments createArguments(ArgumentProviders argumentProviders) {
            HashMap<String, String> args = new HashMap<String, String>();
            for (Map.Entry<String, Object> e : argumentProviders.args().entrySet()) {
                args.put(e.getKey(), e.getValue().toString());
            }
            for (PromptManager.PromptArgument a : this.arguments) {
                if (a.defaultValue() == null || args.containsKey(a.name())) continue;
                args.put(a.name(), a.defaultValue());
            }
            return new PromptManager.PromptArguments(args, argumentProviders.connection(), PromptManagerImpl.this.log(Feature.PROMPT.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()), ProgressImpl.from(argumentProviders), RootsImpl.from(argumentProviders), SamplingImpl.from(argumentProviders));
        }

        @Override
        public JsonObject asJson() {
            JsonObject prompt = new JsonObject().put("name", (Object)this.name()).put("description", (Object)this.description());
            JsonArray arguments = new JsonArray();
            for (PromptManager.PromptArgument a : this.arguments) {
                arguments.add((Object)new JsonObject().put("name", (Object)a.name()).put("description", (Object)a.description()).put("required", (Object)a.required()));
            }
            prompt.put("arguments", (Object)arguments);
            return prompt;
        }
    }
}

