/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ProgressToken;
import io.quarkiverse.mcp.server.ProgressTracker;
import io.quarkiverse.mcp.server.runtime.ProgressNotificationImpl;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.smallrye.mutiny.Uni;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class ProgressTrackerImpl
implements ProgressTracker {
    private final Sender sender;
    private final ProgressToken token;
    private final BigDecimal total;
    private final BigDecimal step;
    private final Function<BigDecimal, String> messageBuilder;
    private final AtomicReference<BigDecimal> val = new AtomicReference<BigDecimal>(BigDecimal.ZERO);

    public ProgressTrackerImpl(Sender sender, ProgressToken token, BigDecimal total, BigDecimal step, Function<BigDecimal, String> messageBuilder) {
        this.sender = sender;
        this.token = token;
        this.total = total;
        this.step = Objects.requireNonNullElse(step, BigDecimal.ONE);
        this.messageBuilder = messageBuilder;
    }

    @Override
    public ProgressToken token() {
        return this.token;
    }

    @Override
    public Uni<Void> advance(BigDecimal value) {
        Objects.requireNonNull(value);
        return Uni.createFrom().deferred(() -> {
            BigDecimal progress = this.val.updateAndGet(p -> {
                BigDecimal next = p.add(value);
                if (this.total != null && next.compareTo(this.total) > 0) {
                    throw new IllegalStateException("Progress exceeded the total");
                }
                return next;
            });
            String message = null;
            if (this.messageBuilder != null) {
                message = this.messageBuilder.apply(progress);
            }
            return new ProgressNotificationImpl(this.sender, this.token, this.total, progress, message).send();
        });
    }

    @Override
    public void advanceAndForget(BigDecimal value) {
        Objects.requireNonNull(value);
        BigDecimal progress = this.val.updateAndGet(p -> {
            BigDecimal next = p.add(value);
            if (this.total != null && next.compareTo(this.total) > 0) {
                throw new IllegalStateException("Progress exceeded the total");
            }
            return next;
        });
        String message = null;
        if (this.messageBuilder != null) {
            message = this.messageBuilder.apply(progress);
        }
        new ProgressNotificationImpl(this.sender, this.token, this.total, progress, message).sendAndForget();
    }

    @Override
    public BigDecimal progress() {
        return this.val.get();
    }

    @Override
    public BigDecimal total() {
        return this.total;
    }

    @Override
    public BigDecimal step() {
        return this.step;
    }
}

