/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.Notification;
import io.quarkiverse.mcp.server.NotificationManager;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Singleton
public class NotificationManagerImpl
extends FeatureManagerBase<Void, NotificationManager.NotificationInfo>
implements NotificationManager {
    final ConcurrentMap<String, NotificationManager.NotificationInfo> notifications = new ConcurrentHashMap<String, NotificationManager.NotificationInfo>();

    NotificationManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        for (FeatureMetadata<Void> notification : metadata.notifications()) {
            NotificationMethod notificationMethod = new NotificationMethod(notification);
            this.notifications.put(this.key(notificationMethod), notificationMethod);
        }
    }

    @Override
    Stream<NotificationManager.NotificationInfo> infos() {
        return this.notifications.values().stream();
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<Void> getInvoker(String id, McpRequest mcpRequest) {
        NotificationManager.NotificationInfo init = (NotificationManager.NotificationInfo)this.notifications.get(id);
        if (init instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)init);
            if (this.matches(init, mcpRequest)) {
                return fi;
            }
        }
        return null;
    }

    @Override
    public NotificationManager.NotificationInfo getNotification(Notification.Type type, String name) {
        return (NotificationManager.NotificationInfo)this.notifications.get(this.key(type, name));
    }

    @Override
    public NotificationManager.NotificationDefinition newNotification(String name) {
        return new NotificationDefinitionImpl(name);
    }

    @Override
    public boolean removeNotification(Predicate<NotificationManager.NotificationInfo> filter) {
        return this.notifications.entrySet().removeIf(e -> filter.test((NotificationManager.NotificationInfo)e.getValue()));
    }

    IllegalArgumentException notificationAlreadyExists(Notification.Type type, String name) {
        return new IllegalArgumentException("A " + String.valueOf((Object)type) + " notification with name [" + name + "] already exits");
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid notification name: " + id, -32602);
    }

    public String key(NotificationManager.NotificationInfo info) {
        return this.key(info.type(), info.name());
    }

    private String key(Notification.Type type, String name) {
        return String.valueOf((Object)Objects.requireNonNull(type)) + "::" + Objects.requireNonNull(name);
    }

    class NotificationMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<Void>
    implements NotificationManager.NotificationInfo {
        private final Notification.Type type;

        private NotificationMethod(FeatureMetadata<Void> metadata) {
            super(NotificationManagerImpl.this, metadata);
            this.type = Notification.Type.valueOf(metadata.info().description());
        }

        @Override
        public Notification.Type type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String serverName() {
            return this.metadata.info().serverName();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public JsonObject asJson() {
            throw new UnsupportedOperationException();
        }
    }

    class NotificationDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<NotificationManager.NotificationInfo, NotificationManager.NotificationArguments, Void, NotificationDefinitionImpl>
    implements NotificationManager.NotificationDefinition {
        private Notification.Type type;

        private NotificationDefinitionImpl(String name) {
            super(name);
        }

        @Override
        public NotificationManager.NotificationDefinition setType(Notification.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public NotificationManager.NotificationInfo register() {
            this.validate(false);
            if (this.type == null) {
                throw new IllegalStateException("Type must be set");
            }
            NotificationDefinitionInfo ret = new NotificationDefinitionInfo(this.name, this.description, this.serverName, this.fun, this.asyncFun, this.runOnVirtualThread, this.type);
            String key = NotificationManagerImpl.this.key(ret);
            NotificationManager.NotificationInfo existing = NotificationManagerImpl.this.notifications.putIfAbsent(key, ret);
            if (existing != null) {
                throw NotificationManagerImpl.this.notificationAlreadyExists(this.type, this.name);
            }
            return ret;
        }
    }

    class NotificationDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<NotificationManager.NotificationArguments, Void>
    implements NotificationManager.NotificationInfo {
        private final Notification.Type type;

        private NotificationDefinitionInfo(String name, String description, String serverName, Function<NotificationManager.NotificationArguments, Void> fun, Function<NotificationManager.NotificationArguments, Uni<Void>> asyncFun, boolean runOnVirtualThread, Notification.Type type) {
            super(name, description, serverName, fun, asyncFun, runOnVirtualThread);
            this.type = type;
        }

        @Override
        public Notification.Type type() {
            return this.type;
        }

        @Override
        public JsonObject asJson() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected NotificationManager.NotificationArguments createArguments(ArgumentProviders argumentProviders) {
            return new NotificationManager.NotificationArguments(argumentProviders.connection(), NotificationManagerImpl.this.log(Feature.NOTIFICATION.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), RootsImpl.from(argumentProviders), SamplingImpl.from(argumentProviders));
        }
    }
}

