/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.ContextSupport;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;

public class McpRequestImpl
implements McpRequest {
    private final String serverName;
    private final Object json;
    private final McpConnectionBase connection;
    private final Sender sender;
    private final SecuritySupport securitySupport;
    private final ContextSupport requestContextSupport;
    private final ManagedContext requestContext;
    private final CurrentIdentityAssociation currentIdentityAssociation;

    public McpRequestImpl(String serverName, Object json, McpConnectionBase connection, Sender sender, SecuritySupport securitySupport, ContextSupport requestContextSupport, CurrentIdentityAssociation currentIdentityAssociation) {
        this.serverName = serverName;
        this.json = json;
        this.connection = connection;
        this.sender = sender;
        this.securitySupport = securitySupport;
        this.requestContextSupport = requestContextSupport;
        this.requestContext = Arc.container().requestContext();
        this.currentIdentityAssociation = currentIdentityAssociation;
    }

    @Override
    public String serverName() {
        return this.serverName;
    }

    @Override
    public Object json() {
        return this.json;
    }

    @Override
    public McpConnectionBase connection() {
        return this.connection;
    }

    @Override
    public Sender sender() {
        return this.sender;
    }

    @Override
    public SecuritySupport securitySupport() {
        return this.securitySupport;
    }

    @Override
    public ContextSupport contextSupport() {
        return this.requestContextSupport;
    }

    @Override
    public void contextStart() {
        SecuritySupport securitySupport = this.securitySupport();
        ContextSupport contextSupport = this.contextSupport();
        if (this.requestContext.isActive()) {
            if (securitySupport != null && this.currentIdentityAssociation != null) {
                securitySupport.setCurrentIdentity(this.currentIdentityAssociation);
            }
        } else {
            this.requestContext.activate();
            if (contextSupport != null) {
                contextSupport.requestContextActivated();
            }
            if (securitySupport != null && this.currentIdentityAssociation != null) {
                securitySupport.setCurrentIdentity(this.currentIdentityAssociation);
            }
        }
    }

    @Override
    public void contextEnd() {
        this.requestContext.terminate();
    }
}

