/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.inject.Singleton;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class ConnectionManager
implements Iterable<McpConnectionBase> {
    private final Vertx vertx;
    private final ResponseHandlers responseHandlers;
    private final ConcurrentMap<String, ConnectionTimerId> connections = new ConcurrentHashMap<String, ConnectionTimerId>();

    public ConnectionManager(Vertx vertx, ResponseHandlers responseHandlers, McpServersRuntimeConfig servers, McpMetadata metadata) {
        this.vertx = vertx;
        this.responseHandlers = responseHandlers;
        long minConnectionIdleTimeout = this.findMinimalConnectionIdleTimeout(servers, metadata);
        if (minConnectionIdleTimeout > 0L) {
            vertx.setPeriodic(minConnectionIdleTimeout / 2L, (Handler)new Handler<Long>(){

                public void handle(Long event) {
                    ConnectionManager.this.connections.values().removeIf(ConnectionTimerId::isIdleTimeoutExpired);
                }
            });
        }
    }

    @Override
    public Iterator<McpConnectionBase> iterator() {
        return this.connections.values().stream().map(ConnectionTimerId::connection).iterator();
    }

    public boolean has(String id) {
        return this.connections.containsKey(id);
    }

    public McpConnectionBase get(String id) {
        ConnectionTimerId connectionTimerId = (ConnectionTimerId)this.connections.get(id);
        return connectionTimerId != null ? connectionTimerId.connection().touch() : null;
    }

    public void add(final McpConnectionBase connection) {
        Long timerId = null;
        if (connection.autoPingInterval().isPresent()) {
            timerId = this.vertx.setPeriodic(connection.autoPingInterval().get().toMillis(), (Handler)new Handler<Long>(){

                public void handle(Long timerId) {
                    connection.send(Messages.newPing(ConnectionManager.this.responseHandlers.nextId()));
                }
            });
        }
        this.connections.put(connection.id(), new ConnectionTimerId(connection, timerId));
    }

    public boolean remove(String id) {
        ConnectionTimerId connection = (ConnectionTimerId)this.connections.remove(id);
        if (connection != null) {
            connection.connection().close();
            if (connection.timerId() != null) {
                this.vertx.cancelTimer(connection.timerId().longValue());
            }
            return true;
        }
        return false;
    }

    private long findMinimalConnectionIdleTimeout(McpServersRuntimeConfig config, McpMetadata metadata) {
        HashSet<String> serverNames = new HashSet<String>(metadata.serverNames());
        serverNames.addAll(config.servers().keySet());
        if (serverNames.isEmpty()) {
            return 0L;
        }
        long min = Long.MAX_VALUE;
        for (String serverName : serverNames) {
            long timeout = config.servers().get(serverName).connectionIdleTimeout().toMillis();
            if (timeout >= min) continue;
            min = timeout;
        }
        return min;
    }

    public static String connectionId() {
        return Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
    }

    record ConnectionTimerId(McpConnectionBase connection, Long timerId) {
        boolean isIdleTimeoutExpired() {
            return this.connection.isIdleTimeoutExpired();
        }
    }
}

