/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.jboss.logging.Logger;

public abstract class CompletionMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(CompletionMessageHandler.class);
    private final ResponseHandlers responseHandlers;

    protected CompletionMessageHandler(ResponseHandlers responseHandlers) {
        this.responseHandlers = responseHandlers;
    }

    protected abstract Future<CompletionResponse> execute(String var1, ArgumentProviders var2, McpRequest var3) throws McpException;

    Future<Void> complete(JsonObject message, Object id, JsonObject ref, JsonObject argument, Sender sender, McpRequest mcpRequest) {
        String referenceName = ref.getString("name");
        String argumentName = argument.getString("name");
        LOG.debugf("Complete %s for argument %s [id: %s]", (Object)referenceName, (Object)argumentName, id);
        String key = referenceName + "_" + argumentName;
        ArgumentProviders argProviders = new ArgumentProviders(Map.of(argumentName, argument.getString("value")), mcpRequest.connection(), id, null, sender, Messages.getProgressToken(message), this.responseHandlers, mcpRequest.serverName());
        try {
            Future<CompletionResponse> fu = this.execute(key, argProviders, mcpRequest);
            return fu.compose(completionResponse -> {
                JsonObject result = new JsonObject();
                JsonObject completion = new JsonObject().put("values", completionResponse.values());
                if (completionResponse.total() != null) {
                    completion.put("total", (Object)completionResponse.total());
                }
                if (completionResponse.hasMore() != null) {
                    completion.put("hasMore", (Object)completionResponse.hasMore());
                }
                result.put("completion", (Object)completion);
                return sender.sendResult(id, result);
            }, cause -> this.handleFailure(id, sender, mcpRequest.connection(), (Throwable)cause, LOG, "Unable to complete %s", referenceName));
        }
        catch (McpException e) {
            return sender.sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

