/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.EmbeddedResource;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.TextContent;

public record SamplingMessage(Role role, Content content) {
    public SamplingMessage {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        if (content instanceof EmbeddedResource) {
            throw new IllegalArgumentException("content must not be resource");
        }
    }

    public static SamplingMessage withUserRole(String textContent) {
        return SamplingMessage.withUserRole(new TextContent(textContent));
    }

    public static SamplingMessage withUserRole(Content content) {
        return new SamplingMessage(Role.USER, content);
    }

    public static SamplingMessage withAssistantRole(String textContent) {
        return SamplingMessage.withAssistantRole(new TextContent(textContent));
    }

    public static SamplingMessage withAssistantRole(Content content) {
        return new SamplingMessage(Role.ASSISTANT, content);
    }
}

