/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.TextContent;

public record PromptMessage(Role role, Content content) {
    public PromptMessage {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
    }

    public static PromptMessage withUserRole(String textContent) {
        return PromptMessage.withUserRole(new TextContent(textContent));
    }

    public static PromptMessage withUserRole(Content content) {
        return new PromptMessage(Role.USER, content);
    }

    public static PromptMessage withAssistantRole(String textContent) {
        return PromptMessage.withAssistantRole(new TextContent(textContent));
    }

    public static PromptMessage withAssistantRole(Content content) {
        return new PromptMessage(Role.ASSISTANT, content);
    }
}

