/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.Implementation;
import java.util.List;

public record InitialRequest(Implementation implementation, String protocolVersion, List<ClientCapability> clientCapabilities, Transport transport) {
    public InitialRequest {
        if (implementation == null) {
            throw new IllegalArgumentException("implementation must not be null");
        }
        if (protocolVersion == null) {
            throw new IllegalArgumentException("protocolVersion must not be null");
        }
        if (clientCapabilities == null) {
            throw new IllegalArgumentException("clientCapabilities must not be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("transport must not be null");
        }
    }

    public boolean supportsSampling() {
        return this.supportsCapability("sampling");
    }

    public boolean supportsRoots() {
        return this.supportsCapability("roots");
    }

    public boolean supportsCapability(String name) {
        for (ClientCapability capability : this.clientCapabilities) {
            if (!capability.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static enum Transport {
        STDIO,
        SSE,
        STREAMABLE_HTTP;

    }
}

