/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.mcp.server.AudioContent;
import io.quarkiverse.mcp.server.EmbeddedResource;
import io.quarkiverse.mcp.server.ImageContent;
import io.quarkiverse.mcp.server.TextContent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Content {
    public Type type();

    default public TextContent asText() {
        throw new IllegalArgumentException("Not a text");
    }

    default public ImageContent asImage() {
        throw new IllegalArgumentException("Not an image");
    }

    default public EmbeddedResource asResource() {
        throw new IllegalArgumentException("Not a resource");
    }

    default public AudioContent asAudio() {
        throw new IllegalArgumentException("Not an audio");
    }

    @JsonProperty(value="type")
    default public String getType() {
        return this.type().toString().toLowerCase();
    }

    public static enum Type {
        TEXT,
        IMAGE,
        RESOURCE,
        AUDIO;

    }
}

