/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.Experimental;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsRequest;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsResponse;
import io.quarkiverse.langchain4j.watsonx.bean.WebCrawlerResult;
import io.quarkiverse.langchain4j.watsonx.client.UtilityAgentToolsRestApi;
import io.quarkiverse.langchain4j.watsonx.exception.BuiltinServiceException;
import java.util.Objects;
import java.util.concurrent.Callable;

@Experimental
public class WebCrawlerService {
    private static final ObjectMapper objectMapper = QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER;
    private UtilityAgentToolsRestApi client;

    public WebCrawlerService(UtilityAgentToolsRestApi utilityAgentToolRestApi) {
        this.client = utilityAgentToolRestApi;
    }

    public WebCrawlerResult process(String url) throws BuiltinServiceException {
        if (Objects.isNull(url) || url.isBlank()) {
            throw new IllegalArgumentException("The field \"url\" cannot be null or empty");
        }
        final UtilityAgentToolsRequest request = new UtilityAgentToolsRequest(UtilityAgentToolsRequest.ToolName.WEB_CRAWLER, new UtilityAgentToolsRequest.WebCrawlerInput(url));
        UtilityAgentToolsResponse response = WatsonxUtils.retryOn(new Callable<UtilityAgentToolsResponse>(){
            final /* synthetic */ WebCrawlerService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public UtilityAgentToolsResponse call() throws Exception {
                return this.this$0.client.run(request);
            }
        });
        try {
            return (WebCrawlerResult)objectMapper.readValue((String)objectMapper.readValue(response.output(), String.class), WebCrawlerResult.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

