/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingRequest;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingResponse;
import io.quarkiverse.langchain4j.watsonx.bean.ScoringRequest;
import io.quarkiverse.langchain4j.watsonx.bean.ScoringResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TextChatRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextChatResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TextExtractionRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextExtractionResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TextStreamingChatResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationResponse;
import io.quarkiverse.langchain4j.watsonx.bean.WatsonxError;
import io.quarkiverse.langchain4j.watsonx.exception.WatsonxException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.smallrye.mutiny.Multi;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.StringJoiner;
import org.jboss.resteasy.reactive.RestStreamElementType;

@Path(value="/ml/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface WatsonxRestApi {
    @POST
    @Path(value="text/generation")
    public TextGenerationResponse generation(TextGenerationRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="text/generation_stream")
    @RestStreamElementType(value="application/json")
    public Multi<TextGenerationResponse> generationStreaming(TextGenerationRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="text/chat")
    public TextChatResponse chat(TextChatRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="text/chat_stream")
    @RestStreamElementType(value="application/json")
    public Multi<TextStreamingChatResponse> streamingChat(TextChatRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="text/rerank")
    public ScoringResponse rerank(ScoringRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="text/tokenization")
    public TokenizationResponse tokenization(TokenizationRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="/text/embeddings")
    public EmbeddingResponse embeddings(EmbeddingRequest var1, @QueryParam(value="version") String var2);

    @POST
    @Path(value="/text/extractions")
    public TextExtractionResponse startTextExtractionJob(TextExtractionRequest var1, @QueryParam(value="version") String var2);

    @GET
    @Path(value="text/extractions/{id}")
    public TextExtractionResponse getTextExtractionDetails(@PathParam(value="id") String var1, @QueryParam(value="space_id") String var2, @QueryParam(value="project_id") String var3, @QueryParam(value="version") String var4);

    @ClientExceptionMapper
    public static WatsonxException toException(Response response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            try {
                WatsonxError ex = (WatsonxError)response.readEntity(WatsonxError.class);
                StringJoiner joiner = new StringJoiner("\n");
                if (ex.errors() != null && ex.errors().size() > 0) {
                    for (WatsonxError.Error error : ex.errors()) {
                        joiner.add("%s: %s".formatted(error.code(), error.message()));
                    }
                }
                return new WatsonxException(joiner.toString(), response.getStatus(), ex);
            }
            catch (Exception e) {
                return new WatsonxException((String)response.readEntity(String.class), (Integer)response.getStatus());
            }
        }
        return new WatsonxException((String)response.readEntity(String.class), (Integer)response.getStatus());
    }

    @ClientObjectMapper
    public static ObjectMapper objectMapper(ObjectMapper defaultObjectMapper) {
        return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
    }
}

