/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.bean.IAMError;
import io.quarkiverse.langchain4j.watsonx.bean.IdentityTokenRequest;
import io.quarkiverse.langchain4j.watsonx.bean.IdentityTokenResponse;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.ClientWebApplicationException;

@Path(value="")
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
public interface IAMRestApi {
    @POST
    @Path(value="identity/token")
    public Uni<IdentityTokenResponse> generateBearer(IdentityTokenRequest var1);

    @ClientExceptionMapper
    public static WebApplicationException toException(Response response) {
        if ("text/plain".equals(response.getHeaderString("Content-Type"))) {
            return new WebApplicationException((String)response.readEntity(String.class), response.getStatus());
        }
        try {
            IAMError error = (IAMError)response.readEntity(IAMError.class);
            switch (error.errorCode()) {
                case BXNIM0415E: {
                    throw new WebApplicationException("\"quarkus.langchain4j.watsonx.api-key\" is incorrect", response.getStatus());
                }
            }
            throw new WebApplicationException(error.errorMessage(), response.getStatus());
        }
        catch (ProcessingException | ClientWebApplicationException e) {
            return new WebApplicationException(response);
        }
    }

    @ClientObjectMapper
    public static ObjectMapper objectMapper(ObjectMapper defaultObjectMapper) {
        return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
    }
}

